{*
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2014 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<div class="top1e-search-title">
	{l s='The result search for ' mod='tvsearchautocomplete'} "{$query}"
	
</div>
<div class="items-list">
{if !empty($searchResults)}
	{foreach from=$searchResults item=item key=key}
		<div class="item">
			<div class="image">
				<a href="{$item.link|escape:'htmlall':'UTF-8'}" class="product_img_link" title="{$item.name|escape:'htmlall':'UTF-8'}">						
						<img src="{$link->getImageLink($item.link_rewrite,$item.id_image ,'home_default')}" alt="{$item.legend|escape:'htmlall':'UTF-8'}" />					
				</a>
			</div>	
			<div class="name">
				<a href="{$item.link|escape:'htmlall':'UTF-8'}" class="product_img_link" title="{$item.name|escape:'htmlall':'UTF-8'}">
					{$item.name|escape:'htmlall':'UTF-8'}
				</a>
			</div>
			{if $show_des == 'true'}
			<div class="description">
				{$item.description_short|strip_tags:'UTF-8'|truncate:180:'...'}			
			</div>
			{/if}
			{if $show_addcart == 'true'}
			<div class="cart">
					{if ($item.allow_oosp || $item.quantity > 0)}
						{if isset($static_token)}
							<a class="button ajax_add_to_cart_button exclusive btn btn-default" rel="ajax_id_product_{$item.id_product|intval}" id="{$item.id_product|intval}" href="javascript:void(0);"><span>{l s='Add to Cart' mod='tvsearchautocomplete'}</span></a>
						{else}
							<a class="button ajax_add_to_cart_button exclusive btn btn-default" rel="ajax_id_product_{$item.id_product|intval}" id="{$item.id_product|intval}" href="javascript:void(0);"><span>{l s='Add to Cart' mod='tvsearchautocomplete'}</span></a>
						{/if}						
					{else}
						<span class="exclusive"><span></span>{l s='Out of stock' mod='tvsearchautocomplete'}</span><br />
					{/if}
					
			</div>
			{/if}
			{if $show_view == 'true'}
			<div class="view">	
					<a class="button exclusive lnk_view btn btn-default"  id="{$item.id_product|escape:'htmlall':'UTF-8'}" href="{$item.link|escape:'htmlall':'UTF-8'}"><span>{l s='view details' mod='tvsearchautocomplete'}</span></a>		
			</div>
			{/if}
			{if $show_price == 'true'}
			<div class="price">
					{if isset($item.on_sale) && $item.on_sale && isset($item.show_price) && $item.show_price && !$PS_CATALOG_MODE}<span class="on_sale">{l s='On sale!' mod='tvsearchautocomplete'}</span>
					{elseif isset($item.reduction) && $item.reduction && isset($item.show_price) && $item.show_price && !$PS_CATALOG_MODE}<!--<span class="discount">{l s='Reduced price!' mod='tvsearchautocomplete'}</span>-->{/if}
					{if (!$PS_CATALOG_MODE AND ((isset($item.show_price) && $item.show_price) || (isset($item.available_for_order) && $item.available_for_order)))}
					<div class="content_price">
					{if $item.reduction}<span class="old">{convertPrice price=$item.price_without_reduction}</span>{/if}
					{if isset($item.show_price) && $item.show_price && !isset($restricted_country_mode)}<span class="price-discount" style="display: inline;">{if !$priceDisplay}{convertPrice price=$item.price}{else}{convertPrice price=$item.price_tax_exc}{/if}</span>{/if}
					
					</div>				
					{/if}	
			</div>
			{/if}	
		</div>
		<div style="clear: both;margin-botton: 5px;"></div>
	{/foreach}
	
	<!--<div class="top1e_view_all"><a id="top1e_view_all" href="javascript:view_all()">{l s='View all' mod='tvsearchautocomplete'}</a></div>-->

	{else}
	<div class="noresult">{l s='No found any item!' mod='tvsearchautocomplete'}</div>
{/if}
</div>
