<?php
/**
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2014 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
exit;

class tvsearchautocomplete extends Module
{
		public $limit_item;
	    public $show_addcart;
		public $show_view;
		public $show_des;
		public $show_price;
public function __construct()
{
			$this->name = 'tvsearchautocomplete';
			$this->tab = 'others';
			$this->version = 1.0;
			$this->author = 'Themesvip';			
			$this->module_key = '4ddaa2f6c66dba43730094b1749fabba';
			parent::__construct();			
			$this->displayName = $this->l('TV Live Search Auto Complete');
			$this->description = $this->l('With this module you can easy seach with auto complete.');
			
			$this->limit_item = htmlentities(Configuration::get('LIMIT_ITEM'), ENT_QUOTES, 'UTF-8');
		    $this->show_addcart = htmlentities(Configuration::get('SHOW_VIEW'), ENT_QUOTES, 'UTF-8');
			$this->show_view = htmlentities(Configuration::get('SHOW_ADDCART'), ENT_QUOTES, 'UTF-8');
			$this->show_des = htmlentities(Configuration::get('SHOW_DES'), ENT_QUOTES, 'UTF-8');
			$this->show_price = htmlentities(Configuration::get('SHOW_PRICE'), ENT_QUOTES, 'UTF-8');
	
}

public function install()
{
			Configuration::updateValue('SHOW_ADV',"1");
			Configuration::updateValue('LIMIT_ITEM',5);
		    Configuration::updateValue('SHOW_VIEW',"true");
			Configuration::updateValue('SHOW_ADDCART',"true");
			Configuration::updateValue('SHOW_DES',"true");
			Configuration::updateValue('SHOW_PRICE',"true");
			if (!parent::install() || !$this->registerHook('displayHeader'))
				return false;
			else
				return true;
			
}

public function uninstall()
{
			Configuration::deleteByName('SHOW_ADV');
			Configuration::deleteByName('LIMIT_ITEM');
			Configuration::deleteByName('SHOW_VIEW');
			Configuration::deleteByName('SHOW_ADDCART');
			Configuration::deleteByName('SHOW_DES');
			Configuration::deleteByName('SHOW_PRICE');
			return parent::uninstall();			
}

public function getContent()
{
		
		$this->_html = '<h2><img src="'.$this->_path.'logo.png" alt="" /> '.$this->displayName.'</h2>';
		$this->_postProcess();		
		$this->_displayForm();	
		return $this->_html;
}

private function _postProcess()
{
		$errors = array();
		if (Tools::isSubmit('saveAjaxLiveSearch'))
		{		
			    $limit_item = Tools::getValue('limit_item');
                Configuration::updateValue('LIMIT_ITEM', $limit_item);
                $this->limit_item = htmlentities(Configuration::get('LIMIT_ITEM'), ENT_QUOTES, 'UTF-8');
               
				$show_addcart = Tools::getValue('show_addcart');
                Configuration::updateValue('SHOW_ADDCART', $show_addcart);
                $this->show_addcart = htmlentities(Configuration::get('SHOW_ADDCART'), ENT_QUOTES, 'UTF-8');
			  
			   $show_view = Tools::getValue('show_view');
                Configuration::updateValue('SHOW_VIEW', $show_view);
                $this->show_view = htmlentities(Configuration::get('SHOW_VIEW'), ENT_QUOTES, 'UTF-8');
				
				$show_des = Tools::getValue('show_des');
                Configuration::updateValue('SHOW_DES', $show_des);
                $this->show_des = htmlentities(Configuration::get('SHOW_DES'), ENT_QUOTES, 'UTF-8');
				
				$show_price = Tools::getValue('show_price');
                Configuration::updateValue('SHOW_PRICE', $show_price);
                $this->show_price = htmlentities(Configuration::get('SHOW_PRICE'), ENT_QUOTES, 'UTF-8');
			
				$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));	
		}
		elseif (Tools::isSubmit('saveAjaxLiveSearchConfirmation'))
			$this->_html = $this->displayConfirmation($this->l('Ajax Live Search has been saved successfully'));		
}

private function _displayForm()
{
	 	$this->_html .= '
		
	 	<br/>
		<form method="post" action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" enctype="multipart/form-data">

	 	<fieldset>
			<legend><img src="'.$this->_path.'img/setting.png" alt="" title="" /> '.$this->l('Options').'</legend>
			<table class="table" style="width:100%;">
				<tbody>
					<tr>
						<td style="text-align: center;border:none; padding-top:5px;">
						<label class="t">'.$this->l('Item number on result search: ').'</label>
						<input type="text" name="limit_item" value="'.Configuration::get('LIMIT_ITEM') .'" />
						</td>
				    </tr>
					<tr>
						<td style="text-align: center;border:none; padding-top:5px;>
						<label class="t">'.$this->l('Show add to cart: ').'</label>
						</label><input type="radio" name="show_addcart" value="true" '.(Configuration::get('SHOW_ADDCART') == "true" ? 'checked="checked"' : '').' />
						<label class="t"><img src="'._PS_ADMIN_IMG_.'enabled.gif" alt="Enabled" title="Enabled" /></label>
						<input type="radio" name="show_addcart" value="false" '.(Configuration::get('SHOW_ADDCART') == "false" ? 'checked="checked"' : '').' />
						<label class="t"><img src="'._PS_ADMIN_IMG_.'disabled.gif" alt="Disabled" title="Disabled" /></label>
						<br>
						</td>
					</tr>
					<tr>
						<td style="text-align: center;border:none; padding-top:5px;>
						<label class="t">'.$this->l('Show view button: ').'</label>
						</label><input type="radio" name="show_view" value="true" '.(Configuration::get('SHOW_VIEW') == "true" ? 'checked="checked"' : '').' />
						<label class="t"><img src="'._PS_ADMIN_IMG_.'enabled.gif" alt="Enabled" title="Enabled" /></label>
						<input type="radio" name="show_view" value="false" '.(Configuration::get('SHOW_VIEW') == "false" ? 'checked="checked"' : '').' />
						<label class="t"><img src="'._PS_ADMIN_IMG_.'disabled.gif" alt="Disabled" title="Disabled" /></label>
						<br>
						</td>
					</tr>
					<tr>
						<td style="text-align: center;border:none; padding-top:5px;>
						<label class="t">'.$this->l('Show description: ').'</label>
						</label><input type="radio" name="show_des" value="true" '.(Configuration::get('SHOW_DES') == "true" ? 'checked="checked"' : '').' />
						<label class="t"><img src="'._PS_ADMIN_IMG_.'enabled.gif" alt="Enabled" title="Enabled" /></label>
						<input type="radio" name="show_des" value="false" '.(Configuration::get('SHOW_DES') == "false" ? 'checked="checked"' : '').' />
						<label class="t"><img src="'._PS_ADMIN_IMG_.'disabled.gif" alt="Disabled" title="Disabled" /></label>
						<br>
						</td>
					</tr>
					<tr>
						<td style="text-align: center;border:none; padding-top:5px;>
						<label class="t">'.$this->l('Show price: ').'</label>
						</label><input type="radio" name="show_price" value="true" '.(Configuration::get('SHOW_PRICE') == "true" ? 'checked="checked"' : '').' />
						<label class="t"><img src="'._PS_ADMIN_IMG_.'enabled.gif" alt="Enabled" title="Enabled" /></label>
						<input type="radio" name="show_price" value="false" '.(Configuration::get('SHOW_PRICE') == "false" ? 'checked="checked"' : '').' />
						<label class="t"><img src="'._PS_ADMIN_IMG_.'disabled.gif" alt="Disabled" title="Disabled" /></label>
						<br>
						</td>
					</tr>
				</tbody>
				</table>
			<div style="text-align: center;padding-top:17px;">';
				$this->_html .= '
				<input type="submit" class="button" name="saveAjaxLiveSearch" value="'.$this->l('Save').'" id="saveAjaxLiveSearch" />';		
				$this->_html .= '					
			</div>';
		$this->_html .= '			
		</fieldset>
		
		
		
		</form>';
		
		$this->_html .= '
			</tbody>
			</table>
		</fieldset>';
			
		
}

public function hookdisplayHeader($params)
{
			$this->context->controller->addJS($this->_path.'js/jquery.autocomplete.js');			
			$this->context->controller->addJS($this->_path.'js/top1e_searchautocomplete.js');			
			$this->context->controller->addCSS($this->_path.'css/top1e_searchautocomplete.css');
			return $this->display(__FILE__, 'views/templates/hook/tvsearchautocomplete.tpl');
}
		
public function LiveSearchProduct($id_lang, $expr, $order_by = 'position', $order_way = 'desc', $ajax = false, $use_cookie = true, Context $context = null)
{
		if (!$context)
				$context = Context::getContext();
			$db = Db::getInstance(_PS_USE_SQL_SLAVE_);
			// Only use cookie if id_customer is not present
			if ($use_cookie)
				$id_customer = $context->customer->id;
			else
				$id_customer = 0;
		
		
			if (!Validate::isOrderBy($order_by) || !Validate::isOrderWay($order_way))
				return false;
		
			$intersect_array = array();
			$score_array = array();
			$words = explode(' ', Search::sanitize($expr, $id_lang));
		
			foreach ($words as $key => $word)
				if (!empty($word) && Tools::strlen($word) >= (int)Configuration::get('PS_SEARCH_MINWORDLEN'))
				{
					$word = str_replace('%', '\\%', $word);
					$word = str_replace('_', '\\_', $word);
					$intersect_array[] = 'SELECT si.id_product
					FROM '._DB_PREFIX_.'search_word sw
					LEFT JOIN '._DB_PREFIX_.'search_index si ON sw.id_word = si.id_word
					WHERE sw.id_lang = '.(int)$id_lang.'
					AND sw.id_shop = '.$context->shop->id.'
					AND sw.word LIKE
					'.($word[0] == '-'
							? ' \''.pSQL(Tools::substr($word, 1, PS_SEARCH_MAX_WORD_LENGTH)).'%\''
							: '\''.pSQL(Tools::substr($word, 0, PS_SEARCH_MAX_WORD_LENGTH)).'%\''
					);
		
					if ($word[0] != '-')
						$score_array[] = 'sw.word LIKE \''.pSQL(Tools::substr($word, 0, PS_SEARCH_MAX_WORD_LENGTH)).'%\'';
				}
				else
					unset($words[$key]);
		
				if (!count($words))
					return array();
		
				$score = '';
				if (count($score_array))
					$score = ',(
					SELECT SUM(weight)
					FROM '._DB_PREFIX_.'search_word sw
					LEFT JOIN '._DB_PREFIX_.'search_index si ON sw.id_word = si.id_word
					WHERE sw.id_lang = '.(int)$id_lang.'
					AND sw.id_shop = '.$context->shop->id.'
					AND si.id_product = p.id_product
					AND ('.implode(' OR ', $score_array).')
					) position';
		
				$sql = 'SELECT cp.`id_product`
				FROM `'._DB_PREFIX_.'category_group` cg
				INNER JOIN `'._DB_PREFIX_.'category_product` cp ON cp.`id_category` = cg.`id_category`
				INNER JOIN `'._DB_PREFIX_.'category` c ON cp.`id_category` = c.`id_category`
				INNER JOIN `'._DB_PREFIX_.'product` p ON cp.`id_product` = p.`id_product`
				'.Shop::addSqlAssociation('product', 'p', false).'
				WHERE c.`active` = 1
				AND product_shop.`active` = 1
				AND product_shop.`visibility` IN ("both", "search")
				AND product_shop.indexed = 1
				AND cg.`id_group` '.(!$id_customer ?  '= 1' : 'IN (
						SELECT id_group FROM '._DB_PREFIX_.'customer_group
						WHERE id_customer = '.(int)$id_customer.'
				)');
				$results = $db->executeS($sql);
		
				$eligible_products = array();
				foreach ($results as $row)
					$eligible_products[] = $row['id_product'];
				foreach ($intersect_array as $query)
				{
					$eligible_products2 = array();
					foreach ($db->executeS($query) as $row)
						$eligible_products2[] = $row['id_product'];
		
					$eligible_products = array_intersect($eligible_products, $eligible_products2);
					if (!count($eligible_products))
						return array();
				}
		
				$eligible_products = array_unique($eligible_products);
		
				$product_pool = '';
				foreach ($eligible_products as $id_product)
					if ($id_product)
					$product_pool .= (int)$id_product.',';
				if (empty($product_pool))
					return array();
				$product_pool = ((strpos($product_pool, ',') === false) ? (' = '.(int)$product_pool.' ') : (' IN ('.rtrim($product_pool, ',').') '));
		
				if ($ajax)
				{
					$sql = 'SELECT DISTINCT p.id_product,p.*, pl.name pname, cl.name cname,
					cl.link_rewrite crewrite, pl.link_rewrite prewrite '.$score.'
					FROM '._DB_PREFIX_.'product p
					INNER JOIN `'._DB_PREFIX_.'product_lang` pl ON (
					p.`id_product` = pl.`id_product`
					AND pl.`id_lang` = '.(int)$id_lang.Shop::addSqlRestrictionOnLang('pl').'
					)
					'.Shop::addSqlAssociation('product', 'p').'
					INNER JOIN `'._DB_PREFIX_.'category_lang` cl ON (
					product_shop.`id_category_default` = cl.`id_category`
					AND cl.`id_lang` = '.(int)$id_lang.Shop::addSqlRestrictionOnLang('cl').'
					)
					WHERE p.`id_product` '.$product_pool.'
					ORDER BY position DESC';
					return $db->executeS($sql);
				}
		
				if (strpos($order_by, '.') > 0)
				{
					$order_by = explode('.', $order_by);
					$order_by = pSQL($order_by[0]).'.`'.pSQL($order_by[1]).'`';
				}
				$alias = '';
				if ($order_by == 'price')
					$alias = 'product_shop.';
				$sql = 'SELECT p.*, product_shop.*, stock.out_of_stock, IFNULL(stock.quantity, 0) as quantity,
				pl.`description_short`, pl.`available_now`, pl.`available_later`, pl.`link_rewrite`, pl.`name`,
				image_shop.`id_image`, il.`legend`, m.`name` manufacturer_name '.$score.', product_attribute_shop.`id_product_attribute`,
				DATEDIFF(
				p.`date_add`,
				DATE_SUB(
				NOW(),
				INTERVAL '.(Validate::isUnsignedInt(Configuration::get('PS_NB_DAYS_NEW_PRODUCT')) ? Configuration::get('PS_NB_DAYS_NEW_PRODUCT') : 20).' DAY
				)
				) > 0 new
				FROM '._DB_PREFIX_.'product p
				'.Shop::addSqlAssociation('product', 'p').'
				INNER JOIN `'._DB_PREFIX_.'product_lang` pl ON (
				p.`id_product` = pl.`id_product`
				AND pl.`id_lang` = '.(int)$id_lang.Shop::addSqlRestrictionOnLang('pl').'
				)
				LEFT JOIN `'._DB_PREFIX_.'product_attribute` pa	ON (p.`id_product` = pa.`id_product`)
				'.Shop::addSqlAssociation('product_attribute', 'pa', false, 'product_attribute_shop.`default_on` = 1').'
				'.Product::sqlStock('p', 'product_attribute_shop', false, $context->shop).'
				LEFT JOIN `'._DB_PREFIX_.'manufacturer` m ON m.`id_manufacturer` = p.`id_manufacturer`
				LEFT JOIN `'._DB_PREFIX_.'image` i ON (i.`id_product` = p.`id_product`)'.
				Shop::addSqlAssociation('image', 'i', false, 'image_shop.cover=1').'
				LEFT JOIN `'._DB_PREFIX_.'image_lang` il ON (i.`id_image` = il.`id_image` AND il.`id_lang` = '.(int)$id_lang.')
				WHERE p.`id_product` '.$product_pool.'
				AND ((image_shop.id_image IS NOT NULL OR i.id_image IS NULL) OR (image_shop.id_image IS NULL AND i.cover=1))
				AND (pa.id_product_attribute IS NULL OR product_attribute_shop.id_shop='.(int)$context->shop->id.')
				'.($order_by ? 'ORDER BY  '.$alias.$order_by : '').($order_way ? ' '.$order_way : '').' LIMIT 0, '.Configuration::get('LIMIT_ITEM').'';
				
				$result = $db->executeS($sql);
				if (!$result)
					$result_properties = false;
				else
					$result_properties = Product::getProductsProperties((int)$id_lang, $result);
				
				return $result_properties;
}
}	

