<?php

/*
	* profbcomments module.
	* @author 0RS <goshanmashtet@gmail.com>
	* @copyright Copyright &copy; 2014 Webtet
	* @license    http://www.opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
	* @version 0.1
*/


	if (!defined('_PS_VERSION_'))
	  exit;	
		
	class ProFbComments extends Module
	{	
		 public function __construct()
		  {
			$this->name = 'profbcomments';
			$this->tab = 'front_office_features';
			$this->version = '0.1';
			$this->author = 'Webtet';
			$this->bootstrap = true;
			parent::__construct();
			$this->displayName = $this->l('Facebook Comments');
			$this->description = $this->l('Display Facebook Comments');
			$this->confirmUninstall = $this->l('Are you sure you want to uninstall?'); 
		}

		public function install()
		{
			$profbcolor = array('light', 'dark');
			$profborder = array('social', 'reverse_time', 'time');
		  	return parent::install() &&
			$this->registerHook('displayProductTabContent') &&
			$this->registerHook('displayProductTab') &&
			Configuration::updateValue('PROFBC_URL', 'http://example.com/comments') &&
			Configuration::updateValue('PROFBC_LIMIT', '5') &&
			Configuration::updateValue('PROFBC_WIDTH', '535') &&
			Configuration::updateValue('PROFBC_COLOR', 'light') &&
			Configuration::updateValue('PROFBC_ORDER', 'social');
		  }

		public function uninstall()
		{
		  if (!parent::uninstall() ||
		 	!Configuration::deleteByName('PROFBC_URL')||
		  	!Configuration::deleteByName('PROFBC_LIMIT')||
		 	!Configuration::deleteByName('PROFBC_WIDTH')||
			!Configuration::deleteByName('PROFBC_COLOR')||
			!Configuration::deleteByName('PROFBC_ORDER'))
			return false;
		    return true;
		}
		
			public function getContent()
		{
			$output = null;
	
			if (Tools::isSubmit('submit'.$this->name))
			{
				$profburl = strval(Tools::getValue('PROFBC_URL'));
				$profblimit = strval(Tools::getValue('PROFBC_LIMIT'));
				$profbwidth = strval(Tools::getValue('PROFBC_WIDTH'));
				$profborder = strval(Tools::getValue('PROFBC_ORDER'));
				$profbcolor = strval(Tools::getValue('PROFBC_COLOR'));
					Configuration::updateValue('PROFBC_URL', $profburl);
					Configuration::updateValue('PROFBC_LIMIT', $profblimit);
					Configuration::updateValue('PROFBC_WIDTH', $profbwidth);
					Configuration::updateValue('PROFBC_ORDER', $profborder);
					Configuration::updateValue('PROFBC_COLOR', $profbcolor);
					$output .= $this->displayConfirmation($this->l('Settings updated'));
		}
			return $output.$this->displayForm();
		}
		
		public function displayForm()
		{
			// Get default Language
			$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');
			 
			  $options = array(
        array(
            'id_option' => $this->l('light'),                
            'name' => 'light'             
        ),
        array(
            'id_option' => 'dark',
            'name' => $this->l('dark')
        )
  		  );
		  		  $options2 = array(
        array(
            'id_option' => $this->l('social'),                
            'name' => 'social'             
        ),
        array(
            'id_option' => 'reverse_time',
            'name' => $this->l('reverse_time')
        ),
        array(
            'id_option' => 'time',
            'name' => $this->l('time')
        )
  		  );
			// Init Fields form array
			$fields_form[0]['form'] = array(
				'legend' => array(
					'title' => $this->l('Settings'),
				),
				'input' => array(
					array(
						'type' => 'text',
						'label' => $this->l('URL to comment on'),
						'name' => 'PROFBC_URL',
						'size' => '100',
						'desc' => $this->l('The absolute URL that comments posted in the plugin will be permanently associated with. Stories on Facebook about comments posted in the plugin will link to this URL.')
					),
           			array(
						'type' => 'text',
						'label' => $this->l('Number of Posts'),
						'name' => 'PROFBC_LIMIT',
						'size' => '100',
						'desc' => $this->l('The number of comments to show by default. The minimum value is 1.')
					),
						array(
						'type' => 'text',
						'label' => $this->l('Width'),
						'name' => 'PROFBC_WIDTH',
						'size' => '100',
						'desc' => $this->l('The width (in pixels) of the plugin. The mobile version of the Comments plugin ignores the width parameter, and instead has a fluid width of 100%.')
					),
					array(
					  'type' => 'select',                             
					  'label' => $this->l('Color Scheme'),        
					  'name' => 'PROFBC_COLOR',                  
					  'desc' => $this->l('The color scheme used by the plugin. Can be "light" or "dark".'),                            
					  'options' => array(
						'query' => $options,                          
						'id' => 'id_option',                          
						'name' => 'name'                        
					  )
					),
					array(
					  'type' => 'select',                             
					  'label' => $this->l('Order of Posts'),        
					  'name' => 'PROFBC_ORDER',                  
					  'desc' => $this->l('The order to use when displaying comments. Can be "social", "reverse_time", or "time". '),                            
					  'options' => array(
						'query' => $options2,                          
						'id' => 'id_option',                          
						'name' => 'name'                        
					  )
					)
				),
				'submit' => array(
					'title' => $this->l('Save'),
					'class' => 'button'
				)	
		);
		
				$helper = new HelperForm();

    // Module, t    oken and currentIndex
    $helper->module = $this;
    $helper->name_controller = $this->name;
    $helper->token = Tools::getAdminTokenLite('AdminModules');
    $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

    // Language
    $helper->default_form_language = $default_lang;
    $helper->allow_employee_form_lang = $default_lang;

    // Title and toolbar
    $helper->title = $this->displayName;
	
    $helper->show_toolbar = true;        // false -> remove toolbar
    $helper->toolbar_scroll = true;      // yes - > Toolbar is always visible on the top of the screen.
    $helper->submit_action = 'submit'.$this->name;
	
    $helper->toolbar_btn = array(
        'save' =>
        array(
            'desc' => $this->l('Save'),
            'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.
                '&token='.Tools::getAdminTokenLite('AdminModules'),
        ),
        'back' => array(
            'href' => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules'),
            'desc' => $this->l('Back to list')
        )
    );
				 
				// Load current value
				$helper->fields_value['PROFBC_URL'] = Configuration::get('PROFBC_URL');
				$helper->fields_value['PROFBC_LIMIT'] = Configuration::get('PROFBC_LIMIT');
				$helper->fields_value['PROFBC_WIDTH'] = Configuration::get('PROFBC_WIDTH');
				$helper->fields_value['PROFBC_COLOR'] = Configuration::get('PROFBC_COLOR');
				$helper->fields_value['PROFBC_ORDER'] = Configuration::get('PROFBC_ORDER');
				return $helper->generateForm($fields_form);
	}
				
			// Display module
	public function hookDisplayProductTabContent($params)
		{
		 $this->context->smarty->assign(
			array(
				'profburl' => Configuration::get('PROFBC_URL'),
				'profblimit' => Configuration::get('PROFBC_LIMIT'),
				'profbcolor' => Configuration::get('PROFBC_COLOR'),
				'profbwidth' => Configuration::get('PROFBC_WIDTH'),
				'profborder' => Configuration::get('PROFBC_ORDER')
				  )
				  );
				return $this->display(__FILE__, 'profbcomments.tpl');
		}
			
	public function hookdisplayProductTab($params)
		{
			return $this->display(__FILE__, 'tab.tpl');
		}
}
?>