{*
** @author PrestaShop SA <contact@prestashop.com>
** @copyright  2007-2014 PrestaShop SA
** @version  Release: $Revision: 1.2.0 $
**
** International Registered Trademark & Property of PrestaShop SA
**
** Description: PayPal "Express Checkout" error/warning page
**
** This template is displayed to the customer upon any error received from PayPal
**
** Step 1: The customer is using PayPal Express Checkout to place an order
** Step 2: Your store is communicating with PayPal using your API credentials
** Step 3: If you store is receiving an error from the PayPal API, this one is displayed to the customer
** Step 4: If the error code is specifically 10486, it means that the funding source selected by the customer has no funds
** Therefore, we offer to him/her to go back to PayPal to select another funding source
** For any other error, we are inviting the customer to contact your Customer service via the contact page
**
*}

<h1>{l s='Unexpected payment error' mod='paypalmx'}</h1>
{if isset($paypal_mx_errors.L_ERRORCODE0) && $paypal_mx_errors.L_ERRORCODE0 == 10486}
	<div class="pp_error">
		<p><b>{l s='Unfortunately, the payment was declined by PayPal for one of the following reasons:' mod='paypalmx'}</b></p>
        <ul>
        	<li>{l s='Billing address could not be confirmed' mod='paypalmx'}</li>
            <li>{l s='Transaction exceeds the card limit' mod='paypalmx'}</li>
            <li>{l s='Transaction denied by the card issuer' mod='paypalmx'}</li>
        </ul>
        <p>{l s='Details:' mod='paypalmx'}
            {l s='Short Error Message:' mod='paypalmx'} {$paypal_mx_errors.L_SHORTMESSAGE0|escape:'htmlall':'UTF-8'}<br />
            {l s='Detailed Error Message:' mod='paypalmx'} {$paypal_mx_errors.L_LONGMESSAGE0|escape:'htmlall':'UTF-8'}<br />
            {l s='Error Code:' mod='paypalmx'} {$paypal_mx_errors.L_ERRORCODE0|escape:'htmlall':'UTF-8'}
        </p>
        <p><b>{l s='Please click again on the PayPal Express Checkout button below and select another funding source on the PayPal website:' mod='paypalmx'}</b></p>
        {include file='../hook/express-checkout.tpl' paypal_mx_from_error=1}
    </div>
{else}
    <p class="{if $paypal_mx_errors.ACK == 'Failure'}error{else}info{/if}">
    	<b>{l s='Unfortunately, an error occured while communicating with PayPal.' mod='paypalmx'}</b><br /><br />
        {l s='Short Error Message:' mod='paypalmx'} {$paypal_mx_errors.L_SHORTMESSAGE0|escape:'htmlall':'UTF-8'}<br />
        {l s='Detailed Error Message:' mod='paypalmx'} {$paypal_mx_errors.L_LONGMESSAGE0|escape:'htmlall':'UTF-8'}<br />
        {l s='Error Code:' mod='paypalmx'} {$paypal_mx_errors.L_ERRORCODE0|escape:'htmlall':'UTF-8'}<br />
        {l s='Please' mod='paypalmx'} <b><a href="{$link->getPageLink('contact', true)}">{l s='contact our Customer service' mod='paypalmx'}</a></b> {l s='and mention this error code to get this issue resolved.' mod='paypalmx'}<br />
    </p>
{/if}
