{* Marketing Popup Prestashop module
 * Copyright 2014, Prestaddons
 * Author: Prestaddons
 * Website: http://www.prestaddons.fr
 *}

{extends file="helpers/form/form.tpl"}

{block name="legend"}
	<h3>
		{if isset($field.image)}<img src="{$field.image|escape:'UTF-8'}" alt="{$field.title|escape:'html':'UTF-8'}" />{/if}
		{if isset($field.icon)}<i class="{$field.icon|escape:'UTF-8'}"></i>{/if}
		{$field.title|escape:'html':'UTF-8'}
		<span class="panel-heading-action">
		{foreach from=$toolbar_btn item=btn key=k}
			{if $k != 'modules-list' && $k != 'back'}
				<a id="desc-{$table|escape:'UTF-8'}-{if isset($btn.imgclass)}{$btn.imgclass|escape:'UTF-8'}{else}{$k}{/if}" class="list-toolbar-btn" {if isset($btn.href)}href="{$btn.href|escape:'html':'UTF-8'}"{/if} {if isset($btn.target) && $btn.target}target="_blank"{/if} {if isset($btn.js) && $btn.js}onclick="{$btn.js|escape:'UTF-8'}" {/if}>
					<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s=$btn.desc mod='marketingpopup'}" data-html="true">
						<i class="process-icon-{if isset($btn.imgclass)}{$btn.imgclass|escape:'UTF-8'}{else}{$k}{/if} {if isset($btn.class)}{$btn.class|escape:'UTF-8'}{/if}" ></i>
					</span>
				</a>
			{/if}
		{/foreach}
		</span>
	</h3>
{/block}

{block name="after"}
	{if $psversion16}
	<form action="" id="{$table|escape:'UTF-8'}_form" method="post" class="form-horizontal">
		<div class="panel">
			<h3>
				<i class="icon-star"></i>
				{l s='Additional features' mod='marketingpopup'}
			</h3>
			<div class="form-group">
				<label class="control-label col-lg-3" for="mp_social">{l s='Social networks' mod='marketingpopup'}</label>
				<div class="col-lg-9 ">
					<span class="switch prestashop-switch fixed-width-lg">
						<input type="radio" value="1" {if $mp_social}checked="checked"{/if} id="mp_social_on" name="mp_social">
						<label for="mp_social_on">{l s='Yes' mod='marketingpopup'}</label>
						<input type="radio" value="0" {if !$mp_social}checked="checked"{/if} id="mp_social_off" name="mp_social">
						<label for="mp_social_off">{l s='No' mod='marketingpopup'}</label>
						<a class="slide-button btn"></a>
					</span>
					<p class="preference_description">{l s='Displays social networks icons' mod='marketingpopup'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="facebook">Facebook</label>
				<div class="col-lg-9 ">
					<div class="input-group">
						<input type="text" size="20" class="fixed-width-xxl" value="{$mp_facebook|escape:'UTF-8'}" id="facebook" name="mp_facebook" />
					</div>
					<p class="preference_description">{l s='Facebook url (e.g. https://www.facebook.com)' mod='marketingpopup'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="twitter">Twitter</label>
				<div class="col-lg-9 ">
					<div class="input-group">
						<input type="text" size="20" class="fixed-width-xxl" value="{$mp_twitter|escape:'UTF-8'}" id="twitter" name="mp_twitter" />
					</div>
					<p class="preference_description">{l s='Twitter url (e.g. https://twitter.com)' mod='marketingpopup'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="rss">RSS</label>
				<div class="col-lg-9 ">
					<div class="input-group">
						<input type="text" size="20" class="fixed-width-xxl" value="{$mp_rss|escape:'UTF-8'}" id="rss" name="mp_rss" />
					</div>
					<p class="preference_description">{l s='RSS url (e.g. http://www.prestashop.com/blog/en/feed/)' mod='marketingpopup'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="youtube">Youtube</label>
				<div class="col-lg-9 ">
					<div class="input-group">
						<input type="text" size="20" class="fixed-width-xxl" value="{$mp_youtube|escape:'UTF-8'}" id="youtube" name="mp_youtube" />
					</div>
					<p class="preference_description">{l s='Youtube url (e.g. http://www.youtube.com)' mod='marketingpopup'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="google">Google +</label>
				<div class="col-lg-9 ">
					<div class="input-group">
						<input type="text" size="20" class="fixed-width-xxl" value="{$mp_google|escape:'UTF-8'}" id="google" name="mp_google" />
					</div>
					<p class="preference_description">{l s='Google + url (e.g. https://plus.google.com)' mod='marketingpopup'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="pinterest">Pinterest</label>
				<div class="col-lg-9 ">
					<div class="input-group">
						<input type="text" size="20" class="fixed-width-xxl" value="{$mp_pinterest|escape:'UTF-8'}" id="pinterest" name="mp_pinterest" />
					</div>
					<p class="preference_description">{l s='Pinterest url (e.g. https://www.pinterest.com)' mod='marketingpopup'}</p>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-lg-3" for="mp_newsletter">{l s='Newsletter' mod='marketingpopup'}</label>
				<div class="col-lg-9 ">
					<span class="switch prestashop-switch fixed-width-lg">
						<input type="radio" value="1" {if $mp_newsletter}checked="checked"{/if} id="mp_newsletter_on" name="mp_newsletter">
						<label for="mp_newsletter_on">{l s='Yes' mod='marketingpopup'}</label>
						<input type="radio" value="0" {if !$mp_newsletter}checked="checked"{/if} id="mp_newsletter_off" name="mp_newsletter">
						<label for="mp_newsletter_off">{l s='No' mod='marketingpopup'}</label>
						<a class="slide-button btn"></a>
					</span>
					<p class="preference_description">{l s='Displays the newsletter form' mod='marketingpopup'}</p>
				</div>
			</div>
			<div class="panel-footer">
				<button type="submit" name="submitFeatures" id="{$table}_form_submit_btn" class="btn btn-default pull-right"><i class="process-icon-save"></i> {l s='Save' mod='marketingpopup'}</button>
			</div>
		</div>
	</form>
	<div class="leadin">{block name="leadin"}{/block}</div>
	<form action="" id="{$table|escape:'UTF-8'}_form" method="post" class="form-horizontal">
		<div class="panel">
			<h3>
				<i class="icon-paste"></i>
				{l s='Exceptions management' mod='marketingpopup'}
			</h3>
			<div class="form-group">
				<label class="control-label col-lg-3">{l s='Exceptions' mod='marketingpopup'}</label>
				<div class="col-lg-9">
					<div class="well">
						<p>
							{l s='Please specify the files for which you do not want the Marketing Popup to be displayed.' mod='marketingpopup'}<br />
							{l s='Please input each filename, separated by a comma (",").' mod='marketingpopup'}<br />
							{l s='You can also click the filename in the list below, and even make a multiple selection by keeping the Ctrl key pressed while clicking, or choose a whole range of filename by keeping the Shift key pressed while clicking.' mod='marketingpopup'}<br />
							{$exception_list|escape:'UTF-8'}
						</p>
					</div>
				</div>
			</div>
			<div class="panel-footer">
				<button type="submit" name="submitExceptions" id="{$table}_form_submit_btn" class="btn btn-default pull-right"><i class="process-icon-save"></i> {l s='Save' mod='marketingpopup'}</button>
			</div>
		</div>
	</form>
	<script type="text/javascript">
		//<![CDATA
		function position_exception_textchange() {
			// TODO : Add & Remove automatically the "custom pages" in the "em_list_x"
			var obj = $(this);
			var shopID = obj.attr('id').replace(/\D/g, '');
			var list = obj.closest('form').find('#em_list_' + shopID);
			var values = obj.val().split(',');
			var len = values.length;

			list.find('option').prop('selected', false);
			for (var i = 0; i < len; i++)
				list.find('option[value="' + $.trim(values[i]) + '"]').prop('selected', true);
		}
		function position_exception_listchange() {
			var obj = $(this);
			var shopID = obj.attr('id').replace(/\D/g, '');
			var str = obj.val().join(', ');
			obj.closest('form').find('#em_text_' + shopID).val(str);
		}
		$(document).ready(function(){
			$('form[id="configuration_form"] input[id^="em_text_"]').each(function(){
				$(this).change(position_exception_textchange).change();
			});
			$('form[id="configuration_form"] select[id^="em_list_"]').each(function(){
				$(this).change(position_exception_listchange);
			});
		});
		//]]>
	</script>
	{else}
	<br />
	<form action="{$current|escape:'UTF-8'}&token={$token|escape:'UTF-8'}" id="{$table|escape:'UTF-8'}_form" method="post" class="form-horizontal">
		<fieldset>
			<legend><img src="../img/t/AdminWebservice.gif" />{l s='Additional features' mod='marketingpopup'}</legend>
			<label for="mp_social">{l s='Social networks' mod='marketingpopup'}</label>
			<div class="margin-form">
				<input type="radio" value="1" {if $mp_social}checked="checked"{/if} id="mp_social_on" name="mp_social">
				<label class="t" for="mp_social_on">
					<img title="{l s='Yes' mod='marketingpopup'}" alt="{l s='Yes' mod='marketingpopup'}" src="../img/admin/enabled.gif">
				</label>
				<input type="radio" value="0" {if !$mp_social}checked="checked"{/if} id="mp_social_off" name="mp_social">
				<label class="t" for="mp_social_off">
					<img title="{l s='No' mod='marketingpopup'}" alt="{l s='No' mod='marketingpopup'}" src="../img/admin/disabled.gif">
				</label>
				<p class="preference_description">{l s='Displays social networks icons' mod='marketingpopup'}</p>
			</div>
			<div class="clear"></div>
			<label for="facebook">Facebook</label>
			<div class="margin-form">
				<input type="text" size="20" class="fixed-width-xxl" value="{$mp_facebook|escape:'UTF-8'}" id="facebook" name="mp_facebook" />
				<p class="preference_description">{l s='Facebook url (e.g. https://www.facebook.com)' mod='marketingpopup'}</p>
			</div>
			<div class="clear"></div>
			<label for="twitter">Twitter</label>
			<div class="margin-form">
				<input type="text" size="20" class="fixed-width-xxl" value="{$mp_twitter|escape:'UTF-8'}" id="twitter" name="mp_twitter" />
				<p class="preference_description">{l s='Twitter url (e.g. https://twitter.com)' mod='marketingpopup'}</p>
			</div>
			<div class="clear"></div>
			<label for="rss">RSS</label>
			<div class="margin-form">
				<input type="text" size="20" class="fixed-width-xxl" value="{$mp_rss|escape:'UTF-8'}" id="rss" name="mp_rss" />
				<p class="preference_description">{l s='RSS url (e.g. http://www.prestashop.com/blog/en/feed/)' mod='marketingpopup'}</p>
			</div>
			<div class="clear"></div>
			<label for="youtube">Youtube</label>
			<div class="margin-form">
				<input type="text" size="20" class="fixed-width-xxl" value="{$mp_youtube|escape:'UTF-8'}" id="youtube" name="mp_youtube" />
				<p class="preference_description">{l s='Youtube url (e.g. http://www.youtube.com)' mod='marketingpopup'}</p>
			</div>
			<div class="clear"></div>
			<label for="google">Google +</label>
			<div class="margin-form">
				<input type="text" size="20" class="fixed-width-xxl" value="{$mp_google|escape:'UTF-8'}" id="google" name="mp_google" />
				<p class="preference_description">{l s='Google + url (e.g. https://plus.google.com)' mod='marketingpopup'}</p>
			</div>
			<div class="clear"></div>
			<label for="pinterest">Pinterest</label>
			<div class="margin-form">
				<input type="text" size="20" class="fixed-width-xxl" value="{$mp_pinterest|escape:'UTF-8'}" id="pinterest" name="mp_pinterest" />
				<p class="preference_description">{l s='Pinterest url (e.g. https://www.pinterest.com)' mod='marketingpopup'}</p>
			</div>
			<div class="clear"></div>
			<label for="mp_newsletter">{l s='Newsletter' mod='marketingpopup'}</label>
			<div class="margin-form">
				<input type="radio" value="1" {if $mp_newsletter}checked="checked"{/if} id="mp_newsletter_on" name="mp_newsletter">
				<label class="t" for="mp_newsletter_on">
					<img title="{l s='Yes' mod='marketingpopup'}" alt="{l s='Yes' mod='marketingpopup'}" src="../img/admin/enabled.gif">
				</label>
				<input type="radio" value="0" {if !$mp_newsletter}checked="checked"{/if} id="mp_newsletter_off" name="mp_newsletter">
				<label class="t" for="mp_newsletter_off">
					<img title="{l s='No' mod='marketingpopup'}" alt="{l s='No' mod='marketingpopup'}" src="../img/admin/disabled.gif">
				</label>
				<p class="preference_description">{l s='Displays the newsletter form' mod='marketingpopup'}</p>
			</div>
			<div class="clear"></div>
			<div class="margin-form">
				<input type="submit" value="{l s='Save' mod='marketingpopup'}" name="submitFeatures" id="{$table}_form_submit_btn" class="button" />
			</div>
		</fieldset>
	</form>
	<br />
	<div class="leadin">{block name="leadin"}{/block}</div>
	<form action="{$current|escape:'UTF-8'}&token={$token|escape:'UTF-8'}" id={$table|escape:'UTF-8'}_form method="post">
		<fieldset>
			<legend><img src="../img/t/AdminModulesPositions.gif" />{l s='Exceptions management' mod='marketingpopup'}</legend>
			<script type="text/javascript">
				//<![CDATA
				function position_exception_add(shopID)
				{
					var listValue = $('#em_list_'+shopID).val();
					var inputValue = $('#em_text_'+shopID).val();
					var r = new RegExp('(^|,) *'+listValue+' *(,|$)');
					if (!r.test(inputValue))
						$('#em_text_'+shopID).val(inputValue + ((inputValue.trim()) ? ', ' : '') + listValue);
				}

				function position_exception_remove(shopID)
				{
					var listValue = $('#em_list_'+shopID).val();
					var inputValue = $('#em_text_'+shopID).val();
					var r = new RegExp('(^|,) *'+listValue+' *(,|$)');
					if (r.test(inputValue))
					{
						var rep = '';
						if (new RegExp(', *'+listValue+' *,').test(inputValue))
							$('#em_text_'+shopID).val(inputValue.replace(r, ','));
						else if (new RegExp(listValue+' *,').test(inputValue))
							$('#em_text_'+shopID).val(inputValue.replace(r, ''));
						else
							$('#em_text_'+shopID).val(inputValue.replace(r, ''));
					}
				}
				//]]>
			</script>

			<label>{l s='Exceptions' mod='marketingpopup'} :</label>
			<div class="margin-form">
				{$exception_list|escape:'UTF-8'}

				{l s='Please specify the files for which you do not want the Marketing Popup to be displayed' mod='marketingpopup'}.<br />
				{l s='Please type each filename separated by a comma' mod='marketingpopup'}.
				<br /><br />
			</div>

			<div class="margin-form">
				<input type="submit" value="{l s='Save' mod='marketingpopup'}" name="submitExceptions" id="{$table}_form_submit_btn" class="button" />
			</div>
		</fieldset>
	</form>
	{/if}
{/block}