<?php


/**


 * GMCAdwords.php file defines method to manage integration with Google Adwords


 * @author Business Tech (www.businesstech.fr) - Contact: modules@businesstech.fr


 * @category admin collection


 * @license Business Tech


 * @uses Please read included installation and configuration instructions (PDF format)


 * @see BT_IInstall Interface


 */


 


class BT_GmcAdwords


{


	public function __construct()


	{





	}//__construct


	


	// Category tree for featured categories on homepage


	public static function recursiveCategoryTree(array $aCategories, array $aIndexedCat, $aCurrentCat, $iCurrentIndex = 1, $iDefaultId = null)


    {


        // set variables


        static $_aTmpCat;


        static $_aFormatCat;





        if ($iCurrentIndex == 1) {


            $_aTmpCat = null;


            $_aFormatCat = null;


        }





        if (!isset($_aTmpCat[$aCurrentCat['infos']['id_parent']])) {


            $_aTmpCat[$aCurrentCat['infos']['id_parent']] = 0;


        }


        $_aTmpCat[$aCurrentCat['infos']['id_parent']] += 1;





        // calculate new level


        $aCurrentCat['infos']['iNewLevel'] = $aCurrentCat['infos']['level_depth'] + (version_compare(_PS_VERSION_, '1.5.0', '>') ? 0 : 1);





        // calculate type of gif to display - displays tree in good


        $aCurrentCat['infos']['sGifType'] = (count($aCategories[$aCurrentCat['infos']['id_parent']]) == $_aTmpCat[$aCurrentCat['infos']['id_parent']] ? 'f' : 'b');





        // calculate if checked


        if (in_array($iCurrentIndex, $aIndexedCat)) {


            $aCurrentCat['infos']['bCurrent'] = true;


        }


        else {


            $aCurrentCat['infos']['bCurrent'] = false;


        }





        // define class name with default cat id


        $aCurrentCat['infos']['mDefaultCat'] = ($iDefaultId === null)? 'default' : $iCurrentIndex;





        $_aFormatCat[] = $aCurrentCat['infos'];





        if (isset($aCategories[$iCurrentIndex])) {


            foreach ($aCategories[$iCurrentIndex] as $iCatId => $aCat) {


                if ($iCatId != 'infos') {


                    self::recursiveCategoryTree($aCategories, $aIndexedCat, $aCategories[$iCurrentIndex][$iCatId], $iCatId);


                }


            }


        }


        return $_aFormatCat;


    }


	


	public static function getCategories()


	{


		global $cookie;


		


		$aFormatCat = array();





		// return Home categories


		$aHomeCat = Category::getCategories(intval($cookie->id_lang), false);





		if (!empty($aHomeCat)) {


			// set recursive tree


            $aTmp = current($aHomeCat);


            $aFirst = current($aTmp);


			$oHomeCat = new Category((int)(Configuration::get('GMERCHANTCENTER_HOME_CAT_ID')));


			$aFormatCat = self::recursiveCategoryTree($aHomeCat, array(), $aFirst, (int)($oHomeCat->level_depth));


            unset($aTmp);


            unset($aFirst);


		}


		return $aFormatCat;


	}


	


	public function generateAdwordsInterface($module)


	{


		global $smarty;


		


		$cats = self::getCategories();


		


		if (!empty($cats)) {


			foreach ($cats as $nKey => &$aCategory) {


				$aCategory['sIndent'] = str_repeat('&nbsp;', $aCategory['iNewLevel'] * 5);


			}


		}


		


		$brands = Manufacturer::getManufacturers();


		$suppliers = Supplier::getSuppliers();


		


		$selected_cats = array();


		$selected_brands = array();


		$selected_suppliers = array();


		$tag = array();


		


		if (Tools::getValue('id_tag'))


		{


			$tag = Db::getInstance()->getRow('SELECT * FROM `'._DB_PREFIX_.'gmc_tags` WHERE id_tag = '.(int)(Tools::getValue('id_tag')));


			


			$gmc_cats = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'gmc_tags_cats` WHERE id_tag = '.(int)(Tools::getValue('id_tag')));


			foreach ($gmc_cats as $c)


				$selected_cats[$c['id_category']] = $c['id_category'];


				


			$gmc_brands = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'gmc_tags_brands` WHERE id_tag = '.(int)(Tools::getValue('id_tag')));


			foreach ($gmc_brands as $b)


				$selected_brands[$b['id_brand']] = $b['id_brand'];


				


			$gmc_suppliers = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'gmc_tags_suppliers` WHERE id_tag = '.(int)(Tools::getValue('id_tag')));


			foreach ($gmc_suppliers as $s)


				$selected_suppliers[$s['id_supplier']] = $s['id_supplier'];


		}	


		


		$smarty->assign(array(


			'tag' => $tag,


			'brands' => $brands,


			'suppliers' => $suppliers,


			'cats' => $cats,


			'selected_brands' => $selected_brands,


			'selected_suppliers' => $selected_suppliers,


			'selected_cats' => $selected_cats,


			'path' => __PS_BASE_URI__.'modules/'.$module->name,


			'module_name' => $module->name,


			'token' => Tools::getValue('token')


		));


			


		return $module->display(dirname(__FILE__).'/gmerchantcenter.php', 'adwords-form.tpl');


	}


	


	public function record()


	{


		if (Tools::getValue('id_tag'))	


			$this->update((int)(Tools::getValue('id_tag')));


		else


			$this->insert();


	}


	


	public function insert()


	{


		Db::getInstance()->Execute('INSERT INTO `'._DB_PREFIX_.'gmc_tags` (`name`, `type`) VALUES ("'.pSQL(Tools::getValue('name')).'", "'.pSQL(Tools::getValue('type')).'")');


		$id = (int)(Db::getInstance()->Insert_ID());


		$this->insertInAssociatedTables($id);


	}


	


	public function update($id)


	{


		Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'gmc_tags` SET `name` = "'.pSQL(Tools::getValue('name')).'", `type` = "'.pSQL(Tools::getValue('type')).'" WHERE `id_tag` = '.(int)($id));


		$this->deleteInAssociatedTables($id);


		$this->insertInAssociatedTables($id);


	}


	


	public function delete($id)


	{


		Db::getInstance()->Execute('DELETE FROM `'._DB_PREFIX_.'gmc_tags` WHERE `id_tag` = '.(int)($id));


		$this->deleteInAssociatedTables($id);


	}


	


	public function deleteInAssociatedTables($id)	


	{ 


		Db::getInstance()->Execute('DELETE FROM `'._DB_PREFIX_.'gmc_tags_cats` WHERE `id_tag` = '.(int)($id));


		Db::getInstance()->Execute('DELETE FROM `'._DB_PREFIX_.'gmc_tags_brands` WHERE `id_tag` = '.(int)($id));


		Db::getInstance()->Execute('DELETE FROM `'._DB_PREFIX_.'gmc_tags_suppliers` WHERE `id_tag` = '.(int)($id));


	}


	


	public function insertInAssociatedTables($id)	


	{


		if (!empty($_POST['cats']) && is_array($_POST['cats']) && sizeof($_POST['cats'])) 


			foreach ($_POST['cats'] as $k => $v)


				Db::getInstance()->Execute('INSERT INTO `'._DB_PREFIX_.'gmc_tags_cats` (`id_tag`, `id_category`) VALUES ("'.$id.'", "'.(int)($v).'")');


		


		if (!empty($_POST['brands']) && is_array($_POST['brands']) && sizeof($_POST['brands'])) 


			foreach ($_POST['brands'] as $k => $v)


				Db::getInstance()->Execute('INSERT INTO `'._DB_PREFIX_.'gmc_tags_brands` (`id_tag`, `id_brand`) VALUES ("'.$id.'", "'.(int)($v).'")');


		


		if (!empty($_POST['suppliers']) && is_array($_POST['suppliers']) && sizeof($_POST['suppliers'])) 	


			foreach ($_POST['suppliers'] as $k => $v)


				Db::getInstance()->Execute('INSERT INTO `'._DB_PREFIX_.'gmc_tags_suppliers` (`id_tag`, `id_supplier`) VALUES ("'.$id.'", "'.(int)($v).'")');


	}


	


	public function showConfirm($module, $type = 'update')


	{


		global $smarty;


		


		$smarty->assign(array(


			'path' => __PS_BASE_URI__.'modules/'.$module->name,


			'module_name' => $module->name,


			'token' => Tools::getValue('token')


		));


		


		if ($type == 'delete')


			return $module->display(dirname(__FILE__).'/gmerchantcenter.php', 'adwords-delete-confirm.tpl');


		else


			return $module->display(dirname(__FILE__).'/gmerchantcenter.php', 'adwords-confirm.tpl');


	}


	


	public function loadTags()


	{


		$tags = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'gmc_tags` ORDER BY `name`');


		return json_encode($tags);


	}


	


	public function getTagsForXml($id_product, $id_category_default, $id_manufacturer, $id_supplier)


	{


		$sql = 'SELECT distinct(gt.id_tag), gt.name, gt.type, "cats" as source


			FROM `'._DB_PREFIX_.'gmc_tags` gt


			LEFT JOIN `'._DB_PREFIX_.'gmc_tags_cats` gtc ON (gt.id_tag = gtc.id_tag)


			WHERE gtc.id_category = '.(int)($id_category_default).'


			


			UNION


			


			SELECT distinct(gt.id_tag), gt.name, gt.type, "brands" as source


			FROM `'._DB_PREFIX_.'gmc_tags` gt


			LEFT JOIN `'._DB_PREFIX_.'gmc_tags_brands` gtb ON (gt.id_tag = gtb.id_tag)


			WHERE gtb.id_brand = '.(int)($id_manufacturer).'


			


			UNION ';


			


		if (version_compare(_PS_VERSION_, '1.5', '>'))


			$sql .= ' SELECT distinct(gt.id_tag), gt.name, gt.type, "suppliers" as source 


			FROM `'._DB_PREFIX_.'gmc_tags` gt


			LEFT JOIN `'._DB_PREFIX_.'gmc_tags_suppliers` gts ON (gt.id_tag = gts.id_tag)


			WHERE gts.id_supplier IN (SELECT distinct(id_supplier) FROM `'._DB_PREFIX_.'product_supplier` WHERE id_product = '.(int)($id_product).')';


		else


			$sql .= ' SELECT distinct(gt.id_tag), gt.name, gt.type, "suppliers" as source 


			FROM `'._DB_PREFIX_.'gmc_tags` gt


			LEFT JOIN `'._DB_PREFIX_.'gmc_tags_suppliers` gts ON (gt.id_tag = gts.id_tag)


			WHERE gts.id_supplier = '.(int)($id_supplier);


			


			$data = Db::getInstance()->ExecuteS($sql);


			$tags = array('adwords_labels' => array(), 'adwords_grouping' => array(), 'custom_label' => array());


			


			if (!empty($data) && sizeof($data))


				foreach ($data as $row)


					if (!in_array($row['name'], $tags[$row['type']]))


					$tags[$row['type']][] = $row['name'];


			


			return $tags;


	}


	


	public static function create()


	{


		static $oAdwords;





		if( null === $oAdwords) {


			$oAdwords = new BT_GmcAdwords();


		}


		return $oAdwords;


	}// create


}


