/**

 *  2016 ModuleFactory.co

 *

 *  @author    ModuleFactory.co <info@modulefactory.co>

 *  @copyright 2016 ModuleFactory.co

 *  @license   ModuleFactory.co Commercial License

 */



var FSAC = FSAC || {};

if (!FSAC.hasOwnProperty('dpa_enabled')) {

    FSAC.dpa_enabled = false;

}



FSAC.triggerEvent = function(event_name, parameters) {

    fbq('track', event_name, parameters);

};



FSAC.eventAddToCart = function(id_product) {

    var event_parameters = {};

    if (FSAC.dpa_enabled) {

        event_parameters = {

            content_ids: [id_product],

            content_type: 'product'

        };

    }

    FSAC.triggerEvent('AddToCart', event_parameters);

};



$(document).ready(function(){

    prestashop.on('updateCart', function (event) {

        if (event.hasOwnProperty('reason')) {

            if (event.reason !== undefined) {

                if (event.reason.hasOwnProperty('linkAction')) {

                    if (event.reason.linkAction == 'add-to-cart') {

                        FSAC.eventAddToCart(event.reason.idProduct);

                    }

                }

            }

        }

    });

});