<?php
/**
* 2007-2017 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    Cedric Fontaine <contact@prestashop.com>
*  @copyright 2007-2017 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

class BluesnapDefaultModuleFrontController extends ModuleFrontController
{
    public $ssl = true;

    public function __construct()
    {
        $this->auth = false;
        parent::__construct();
        $this->context = Context::getContext();
        include_once($this->module->getLocalPath().'bluesnap.php');
    }

    /**
     * @see FrontController::initContent()
     */
    public function initContent()
    {
        $this->display_column_left = false;
        $this->display_column_right = false;
        parent::initContent();

        if (Tools::getValue('process') == 'webhook') {
            $this->webhook();
        }
    }

    /**
     * Assign summary template
     */
    public function webhook()
    {
        $bluesnap = new Bluesnap();
        if ($bluesnap->active) {
            if (Tools::getIsset('token') && $bluesnap->getConfig('WEBHOOK_TOKEN') == Tools::getValue('token')) {
                $event = array();
                parse_str(@Tools::file_get_contents('php://input'), $event);
                $this->module->log("IPN CALL RECEIVED\n".print_r($event, true));

                if (sizeof($event)>0 && array_key_exists('transactionType', $event)) {
                    try {
                        $id_cart = (int)Db::getInstance()->getValue(
                            'SELECT `id_cart` FROM `'._DB_PREFIX_.'bluesnap_order`
                            WHERE `bluesnap_reference` = \''.pSQL($event['referenceNumber']).'\''
                        );

                        if ($id_cart) {
                            if ($id_order = Order::getOrderByCartId((int)$id_cart)) {
                                $order = new Order((int)$id_order);

                                if (Validate::isLoadedObject($order)) {
                                    $reference_number = $event['referenceNumber'];
                                    /* We are handling refunds here */
                                    if (Tools::strtoupper($event['transactionType']) == 'REFUND') {
                                        if (strpos($event['reversalReason'], 'BackOffice')===false) {
                                            $refund = ($event['invoiceChargeAmount'])*-1;
                                            $reference_number = $event['referenceNumber'];
                                            $id_order_state = Configuration::get('PS_OS_REFUND');
                                            $template_vars = array();
                                            $orders_collection = Order::getByReference($order->reference);
                                            foreach ($orders_collection->getResults() as $orders) {
                                                // Set new order state
                                                $new_history = new OrderHistory();
                                                $new_history->id_order = (int)$orders->id;
                                                $new_history->changeIdOrderState((int)$id_order_state, $orders, true);
                                                // Save all changes
                                                if ($new_history->addWithemail(true, $template_vars)) {
                                                    Db::getInstance()->Execute('
                                                        UPDATE '._DB_PREFIX_.'bluesnap_order 
                                                        SET `refunded`=1, `refund_amount`=`refund_amount`+'.pSQL($refund).' 
                                                        WHERE `bluesnap_reference`=\''.pSQL($reference_number).'\';');
                                                }
                                            }
                                        }
                                    }
                                    /* We are handling chargebacks here */
                                    elseif (Tools::strtoupper($event['transactionType']) == 'CHARGEBACK') {
                                        if ((int)Configuration::get('PS_OS_ERROR') != -1) {
                                            if ($order->getCurrentState() != (int)Configuration::get('PS_OS_REFUND')) {
                                                $order->setCurrentState((int)Configuration::get('PS_OS_REFUND'));
                                            }
                                        }

                                        Db::getInstance()->Execute('
                                            UPDATE '._DB_PREFIX_.'bluesnap_order 
                                            SET `refunded`=1, `refund_amount`='.pSQL($order->total_paid).' 
                                            WHERE `bluesnap_reference`=\''.pSQL($reference_number).'\';');

                                        $message = new Message();
                                        $message->message = $bluesnap->l('A chargeback occurred on this order and was reported by Bluesnap on').' '.date('Y-m-d H:i:s');
                                        $message->id_order = (int)$order->id;
                                        $message->id_employee = 1;
                                        $message->private = 1;
                                        $message->date_add = date('Y-m-d H:i:s');
                                        $message->add();
                                        $id_lang = (int)$this->context->language->id;
                                        $id_shop = (int)$this->context->shop->id;
                                        $template_vars = array(
                                            '{orderid}' => $order->id,
                                            '{name}' => Configuration::get('PS_SHOP_NAME'),
                                            '{referenceid}' => $event['referenceNumber']
                                        );
                                        Mail::Send(
                                            $id_lang,
                                            'chargeback',
                                            sprintf(Mail::l('Important: New chargeback received for Order ID : #%d', $id_lang), $order->id),
                                            $template_vars,
                                            Configuration::get('PS_SHOP_EMAIL'),
                                            null,
                                            Configuration::get('PS_SHOP_EMAIL'),
                                            'BlueSnap',
                                            null,
                                            null,
                                            dirname(__FILE__).'/../../mails/',
                                            null,
                                            $id_shop
                                        );
                                    }
                                }
                            }
                        }
                    } catch (Exception $e) {
                        $this->setHttpResponseCode(200);
                        exit;
                    }
                    $this->setHttpResponseCode(200);
                    exit;
                }
            }
        }
        $this->setHttpResponseCode(200);
        exit;
    }
    
    private function setHttpResponseCode($code = null)
    {
        if (!function_exists('http_response_code')) {
            if ($code !== null) {
                $text = 'OK';
                $protocol = (isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.1');
                header($protocol . ' ' . $code . ' ' . $text);
                $GLOBALS['http_response_code'] = $code;
            } else {
                $code = (isset($GLOBALS['http_response_code']) ? $GLOBALS['http_response_code'] : 200);
            }

            return $code;
        } else {
            return http_response_code($code);
        }
    }
}
