<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from Common-Services Co., Ltd.
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: contact@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe Common-Services Co., Ltd.
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la Common-Services Co. Ltd. est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter Common-Services Co., Ltd. a l'adresse: contact@common-services.com
 *
 * @author    Olivier B.
 * @copyright Copyright (c) 2011-2018 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @license   Commercial license
 * @package   Amazon Market Place
 * Support by mail:  support.amazon@common-services.com
*/

class AmazonConfiguration
{
    /**
     * Stores huges configuration sets into marketplace_configuration table instead of ps_configuration table, which is limited
     * @param $configuration_key
     * @param $data
     * @return bool
     */
    public static function updateValue($configuration_key, $data)
    {
        $prestashop_configuration_key = sprintf('AMAZON_%s', Tools::strtoupper($configuration_key));
        $marketplace_configuration_key = Tools::strtolower($configuration_key);

        if (AmazonTools::tableExists(_DB_PREFIX_.'marketplace_configuration')) {
            // Ok the table is present, new method :)

            return (Db::getInstance()->execute('REPLACE INTO `'._DB_PREFIX_.'marketplace_configuration`
                    (`marketplace`, `configuration`, `value`) VALUES ("'.pSQL(Amazon::MARKETPLACE).'", "'.pSQL($marketplace_configuration_key).'", "'.pSQL(AmazonTools::encode(serialize(self::filter($data)))).'"); '));
        } else {
            // old method

            if (version_compare(_PS_VERSION_, '1.5', '>=')) {
                return Configuration::updateGlobalValue($prestashop_configuration_key, pSQL(AmazonTools::encode(serialize(self::filter($data)))));
            } else {
                return Configuration::updateValue($prestashop_configuration_key, pSQL(AmazonTools::encode(serialize(self::filter($data)))));
            }
        }
    }

    /**
     * Retrieves configuration from ps_marketplace
     * @param $configuration_key
     * @return bool|mixed
     */
    public static function get($configuration_key)
    {
        $prestashop_configuration_key = sprintf('AMAZON_%s', Tools::strtoupper($configuration_key));
        $marketplace_configuration_key = Tools::strtolower($configuration_key);

        if (AmazonTools::tableExists(_DB_PREFIX_.'marketplace_configuration')) {
            $result = Db::getInstance()->getRow('SELECT `value` FROM `'._DB_PREFIX_.'marketplace_configuration` WHERE `marketplace` = "'.pSQL(Amazon::MARKETPLACE).'" AND `configuration`="'.pSQL($marketplace_configuration_key).'"');
        } else {
            $result = null;
        }

        if (isset($result['value'])) {
            // New Method

            return (unserialize(AmazonTools::decode($result['value'])));
        } else {
            // Old Method

            if (version_compare(_PS_VERSION_, '1.5', '>=')) {
                $conf = Configuration::getGlobalValue($prestashop_configuration_key);
            } else {
                $conf = Configuration::get($prestashop_configuration_key);
            }

            if ($conf == false) {
                return (false);
            } else {
                return @unserialize(AmazonTools::decode($conf));
            }
        }
    }

    /**
     * As per her sister: Configuration::deleteByName
     * @param $configuration_key
     * @return bool
     */
    public static function deleteKey($configuration_key)
    {
        $prestashop_configuration_key = sprintf('AMAZON_%s', Tools::strtoupper($configuration_key));
        $marketplace_configuration_key = Tools::strtolower($configuration_key);

        $pass = Configuration::deleteByName($prestashop_configuration_key);

        if (AmazonTools::tableExists(_DB_PREFIX_.Amazon::TABLE_MARKETPLACE_CONFIGURATION)) {
            return ($pass && Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.Amazon::TABLE_MARKETPLACE_CONFIGURATION.'`
                    WHERE `marketplace`="'.pSQL(Amazon::MARKETPLACE).'" AND `configuration`="'.pSQL($marketplace_configuration_key).'"'));
        }

        return ($pass);
    }


    public static function filter($obj)
    {
        return ($obj);//TODO: filter SimpleXMLElements

        if ($obj instanceof SimpleXMLElement) {
            return (null);
        } elseif (is_object($obj)) {
            foreach ($obj as $key => $val) {
                $obj->{$key} = self::filter($val);
            }
        } elseif (is_array($obj)) {
            foreach ($obj as $key => $val) {
                $obj[$key] = self::filter($val);
            }
        }

        return $obj;
    }

    public static function combinationIsFeatureActive()
    {
        if (version_compare(_PS_VERSION_, '1.5', '<')) {
            return(true);
        } else {
            return(Combination::isFeatureActive());
        }
    }

    public static function featureIsFeatureActive()
    {
        if (version_compare(_PS_VERSION_, '1.5', '<')) {
            return(true);
        } else {
            return(Feature::isFeatureActive());
        }
    }
    
    public static function shopIsFeatureActive()
    {
        if (version_compare(_PS_VERSION_, '1.5', '<')) {
            return(false);
        } else {
            return(Shop::isFeatureActive());
        }
    }
}
