<?php
/**
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2014 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

class TVFeatureCategory extends Module
{
public function __construct()
{
		$this->name = 'tvfeaturecategory';
		$this->tab = 'others';
		$this->version = '1.0';
		$this->author = 'Themesvip';
		$this->module_key = '4ddaa2f6c66dba43730094b1749fabba';
		$this->bootstrap = true;

		parent::__construct();

		$this->displayName = $this->l('TV Home Featured Category');
		$this->description = $this->l('Displays Featured Category on your homepage.');
}

public function install()
{
		$arrCheck = array(0 => '3', 1 => '4', 2 => '8');
		$cat = implode(',', $arrCheck );
		Configuration::updateValue('NBR_SUBCAT_SHOW',6);
		Configuration::updateValue('TV_FEATURED_ID_CAT',$cat,false,null,Configuration::get('PS_SHOP_DEFAULT'));
		if (!parent::install() OR !$this->registerHook('header') OR !$this->registerHook('homebottom'))
			return false;
		return true;
}

public function uninstall()
{
		Configuration::deleteByName('NBR_SUBCAT_SHOW');
		Configuration::deleteByName('TV_FEATURED_ID_CAT');
		if (!parent::uninstall())
			return false;
		return true;
}

public function getContent()
{
		$output = '';
		if (Tools::isSubmit('submitSaveFeatureCategory'))
		{		
			$nbr_subcat_show = Tools::getValue('nbr_subcat_show');
			Configuration::updateValue('NBR_SUBCAT_SHOW', $nbr_subcat_show);
			
			if (Tools::getValue('categoryBox') != '')
			{
				$cat = implode(',', Tools::getValue('categoryBox'));
				if (Shop::getContext() != Shop::CONTEXT_SHOP)
					foreach (Shop::getContextListShopID() as $id_shop)
					{
					Configuration::updateValue('TV_FEATURED_ID_CAT', $cat,false,null,$id_shop);		
					}
				else
					Configuration::updateValue('TV_FEATURED_ID_CAT',$cat);	
			}
			else
				Configuration::updateValue('TV_FEATURED_ID_CAT', '');
				$output .= $this->displayConfirmation($this->l('Settings updated'));
		}
		return $output.$this->displayForm();
}
		
public static function getCheckboxCatalog($arrCheck,$categories, $current, $id_category = 1, $has_suite = array())
{
		$done = array();
		static $irow;
		if (!isset($done[$current['infos']['id_parent']]))
			$done[$current['infos']['id_parent']] = 0;
		$done[$current['infos']['id_parent']] += 1;
		if (isset($categories[$current['infos']['id_parent']]))
			$todo = sizeof($categories[$current['infos']['id_parent']]);
		$doneC = $done[$current['infos']['id_parent']];
		$level = $current['infos']['level_depth'] + 1;
		
		if ($id_category != 1)
		{
			$result = '
			<tr class="'.($irow++ % 2 ? 'alt_row' : '').'">
				<td>
					<input type="checkbox" name="categoryBox[]" class="categoryBox" id="categoryBox_'.$id_category.'" value="'.$id_category.'"'.(in_array($id_category, $arrCheck) ? ' checked="checked"' : '').'/>
				</td>
				<td>
					'.$id_category.'
				</td>
				<td>';
				for ($i = 2; $i < $level; $i++)
					$result .= '<img src="../img/admin/lvl_'.$has_suite[$i - 2].'.gif" alt="" />';
				$result .= '<img style="vertical-align:middle" src="../img/admin/'.($level == 1 ? 'lv1.gif' : 'lv2_'.($todo == $doneC ? 'f' : 'b').'.gif').'" alt="" /> &nbsp;
				<label for="categoryBox_'.$id_category.'" class="t">'.Tools::stripslashes($current['infos']['name']).'</label></td>
			</tr>';
		}
		else
			$result = '';	
		if ($level > 1)
			$has_suite[] = ($todo == $doneC ? 0 : 1);
		if (isset($categories[$id_category]))
			foreach ($categories[$id_category] AS $key => $row)
				if ($key != 'infos')
					$result.= self::getCheckboxCatalog($arrCheck,$categories, $categories[$id_category][$key], $key, $has_suite);
		return $result;
}

public function displayForm()
{
		$categories = Category::getCategories((int)($this->context->language->id), false);
		$id = (int)Context::getContext()->shop->id;
		$id_shop = $id ? $id: Configuration::get('PS_SHOP_DEFAULT');
		if (Configuration::get('TV_FEATURED_ID_CAT') == '')
			$str_cat = '3,4,8';
		else
			$str_cat = Configuration::get('TV_FEATURED_ID_CAT');  
		
		$arrCheck = explode(',',$str_cat);
		
		$id_root = Configuration::get('PS_ROOT_CATEGORY',null,null,$id_shop);
		$id_home = $this->getRootCategoryForAShop();
		$output = '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post" class="form-horizontal">
			<div class="panel">
			<div class="panel-heading">
			<img src="'.$this->_path.'logo.png" alt="" title="" /> '.$this->l('Feature Category').'
			</div>
				<div class="form-group">
					<p class="clear">Mark all checkbox(es) of categories which have products appear in your homepage<sup> *</sup></p>
				</div>
				<div class="form-group">
					<label class="control-label col-lg-3">Number sub-category show:</label>
					<div class="col-lg-9">
						<input type="text" name="nbr_subcat_show" value="'.Configuration::get('NBR_SUBCAT_SHOW').'" />
					</div>
				</div>

				<div style="overflow: auto; min-height: 300px;" id="categoryList">
					<table cellspacing="0" cellpadding="0" class="table">
						<tr>
							<th>c</th>
							<th>ID</th>
							<th style="width: 600px">Category</th>
						</tr>'
						.$this->getCheckboxCatalog($arrCheck,$categories,$categories[$id_root][$id_home],1).
					'</table>
				</div>
				<br/>
				
				<div class="panel-footer"><button type="submit" name="submitSaveFeatureCategory" class="btn btn-default pull-right" /><i class="process-icon-save"></i>'.$this->l('Save').'</button></div>
			</div>
		</form>';
		return $output;
}	

public function getRootCategoryForAShop()
{
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('
		SELECT `id_category`
		FROM `'._DB_PREFIX_.'shop`
		WHERE `id_shop` = '.(int)$this->context->shop->id);
}

public function preHook()
{
		$category_list = array();
		$link = $this->context->link;
		if (Configuration::get('TV_FEATURED_ID_CAT') != '')
			$str_cat=Configuration::get('TV_FEATURED_ID_CAT');
		else
			$str_cat = '3,4,8';

	if ($str_cat != '')
		{
			$id_cat = explode(',',$str_cat);		
			foreach ($id_cat as $id)
			{	
				$categories = new Category($id,(int)(Context::getcontext()->language->id));
				$category_list[$id]['name_category'] = $categories->name;
				$category_list[$id]['id_category'] = $categories->id;
				$category_list[$id]['link_category'] = $link->getCategoryLink($id);
				$category_list[$id]['id_image'] = $categories->id_image;
				$category_list[$id]['img_cat'] = $link->getCatImageLink($categories->link_rewrite,$categories->id_image,'home-category');
				
				$cat_child = Category::getChildren($id,(int)(Context::getcontext()->language->id));
				if (is_array($cat_child) && count($cat_child)>0)
				{
					$category_list[$id]["list_cat_child"] = $cat_child;
					foreach($cat_child as $acat)
					{
						$sub_cat_id = $acat['id_category'];
						
						$categories_sub = new Category($sub_cat_id,(int)(Context::getcontext()->language->id));
						$category_list[$id][$sub_cat_id]['name'] = $categories_sub->name;
						$category_list[$id][$sub_cat_id]['link_sub_cat'] = $link->getCategoryLink($sub_cat_id);	
					}
				}		
			}
		}
		return $category_list;
}

public function hookHomeBottom($params)
{
		$category_list = array();
		$category_list = $this->preHook();
		$this->context->smarty->assign(array(
			'category_list' => $category_list,
			'path' => $this->_path,
			'nbr_subcat_show' => Configuration::get('NBR_SUBCAT_SHOW')
			));
		return $this->display(__FILE__, 'tvfeaturecategory.tpl');
}

public function hookHeader($params)
{
		require_once(_PS_TOOL_DIR_.'mobile_Detect/Mobile_Detect.php');
		$detect = new Mobile_Detect();
		if ($detect->isMobile())
			$isMobileIp = 1;
		else
			$isMobileIp = 0;	
		$this->context->smarty->assign(array(
			'isMobileIp' =>$isMobileIp
		));	
		$this->context->controller->addCSS($this->_path.'css/tvfeaturecategory.css', 'screen');
}
}
