<?php
/*
* 2008-2011 Librasoft
*
*  @author Librasoft <contact@librasoft.fr>
*  @copyright  2008-2011 Librasoft
*  @version  Release: $Revision: 0.1 $
*  International Registered Trademark & Property of Librasoft
*
*  For support feel free to contact us on our forum at http://www.librasoft.fr/forum/
*
*/

if(!(_PS_VERSION_<'1.4'))
{
	if (!defined('_CAN_LOAD_FILES_'))
		exit;
}
	
class protectmyshop extends Module
{
	private $banlist;
	private $banlistarray;
	private $adminpasswd;
	private $protectfolders;
	private $protectthemes;
	private $protectimg;
	private $protectscripts;
	private $protectadmin;
	private $htaccessexist;
	private $htaccesschmod;
	private $htaccessdata;
	private $htaccessnbline;
	private $cheminracine;
	private $cheminmodule;
	private $admfolder;
	
	public function __construct()
	{
		$this->name = 'protectmyshop';
		$this->tab = 'front_office_features';
		$this->version = 0.1;
		$this->author = 'Librasoft';

		parent::__construct();

		$this->displayName = $this->l('Protect My Shop');
		$this->description = $this->l('A module which protects your shop against thiefs and hackers.');
		$temp = substr($_SERVER['REQUEST_URI'],strlen(__PS_BASE_URI__),strlen($_SERVER['REQUEST_URI'])-strlen(__PS_BASE_URI__));
		$temp2 = substr($temp,0,strpos($temp,"/index.php"));
		Configuration::updateValue('PMS_AdmFolder', $temp2);
		if ($this->id AND (!Configuration::get('PMS_AdmFolder')))
			$this->warning = $this->l('Protect My Shop : Please visit the configuration page.');
		$this->confirmUninstall = $this->l('Are you sure you want to delete your parameters ?');
		$this->refreshSettings();
	}
	
	private function refreshSettings()
	{
		$this->banlist = Configuration::get('PMS_BanList');
		$this->admfolder = Configuration::get('PMS_AdmFolder');
		$this->banlistarray = Array();
		$this->banlistarray = explode(';',$this->banlist);
		$this->passwordnbline = 0;		// *
		$this->protectfolders = false;	// *
		$this->protectthemes = false;	// *
		$this->protectimg = false;		// *
		$this->protectscripts = false;	// *
		$this->protectadmin = false;	// *
		$this->protectfiles = false;	// *
		$this->htaccessexist = false;	// *
		$this->htaccesschmod = false;	// *
		$this->htaccessnbline = 0;		// *
		$this->protectsql = Configuration::get('PMS_SQLINJECT');
		$this->cheminracine = $_SERVER["DOCUMENT_ROOT"].__PS_BASE_URI__;
		$this->cheminmodule = _MODULE_DIR_.$this->name;
		// Test la prsence des fichiers inutiles
		if(!file_exists($this->cheminracine."docs") && !file_exists($this->cheminracine."readme_fr.txt") && !file_exists($this->cheminracine."readme_en.txt") && !file_exists($this->cheminracine."readme_es.txt") && !file_exists($this->cheminracine."readme_de.txt") && !file_exists($this->cheminracine."readme_it.txt") && !file_exists($this->cheminracine."CHANGELOG") && !file_exists($this->cheminracine."README"))
		{
			$this->protectfiles = true;
		}
		// Test la prsence du .htaccess admin
		if(file_exists($this->cheminracine.$this->admfolder."/.password"))
		{
			// Ok le fichier .htaccess admin existe bien
			$this->adminpasswd = Array();
			// On lit le contenu du .password
			if (!$fp = fopen($this->cheminracine.$this->admfolder."/.password","r")) {
				echo "Echec de l'ouverture du fichier .htaccess admin";
				exit;
			}else{
				$i=0;
				while(!feof($fp)) {
					// On lit le fichier
					$this->adminpasswd[$i] = fgets($fp);
					if($this->adminpasswd[$i]!="")
						$i++;
				}
				$this->passwordnbline = $i;
				fclose($fp); // On ferme le fichier
			}
			if ($this->passwordnbline != 0 && file_exists($this->cheminracine.$this->admfolder."/.htaccess"))
			{
				$this->protectadmin = true;
			}
		}
		// Test la prsence du .htaccess
		if(file_exists($this->cheminracine.".htaccess"))
		{
			// Ok le fichier .htaccess existe bien
			$this->htaccessexist = true;
			// On teste ses permissions
			if(substr(sprintf("%o",fileperms($this->cheminracine.".htaccess")),-4) <= "0404")
			{
				// Permission Ok
				$this->htaccesschmod = true;
			}
			$this->htaccessdata = array();
			// On lit le contenu du .htaccess
			if (!$fp = fopen($this->cheminracine.".htaccess","r")) {
				echo "Echec de l'ouverture du fichier .htaccess";
				exit;
			}else{
				$i=0;
				while(!feof($fp)) {
					// On lit le fichier
					$this->htaccessdata[$i] = fgets($fp);
					$i++;
				}
				$this->htaccessnbline = $i;
				fclose($fp); // On ferme le fichier
				// On teste les protections htaccess
				if($this->htaccess_find("Options -Indexes") != '-1')
				{
					// Les rpertoires sont correctement protgs
					$this->protectfolders = true;
				}
				if($this->htaccess_find('<FilesMatch "\.tpl$">') != '-1')
				{
					// Les thmes sont correctement protgs
					$this->protectthemes = true;
				}
				if($this->htaccess_find("RewriteCond %{REQUEST_URI} ^.*\.(js|css)$ [NC]") != '-1')
				{
					// Les scripts et CSS sont correctement protgs
					$this->protectscripts = true;
				}
				if($this->htaccess_find("RewriteRule \.(gif|jpe?g|swf|flv|png|bmp)$ antivolimage.jpg [L,NC]") != '-1')
				{
					// Les images sont correctement protgs
					$this->protectimg = true;
				}
			}
		}
	}
	
	private function htaccess_find($text2find)
	{
		$val2return = '-1';
		for($i=0;$i<$this->htaccessnbline;$i++)
		{
			if(stristr($this->htaccessdata[$i], $text2find) === FALSE) {
			}else{
				$val2return = $i;
			}			
		}
		return $val2return;
	}
	
	public function install()
	{
		if (!parent::install() OR !$this->registerHook('header'))
			return false;
		@copy($this->cheminracine."modules/".$this->name."/img/antivolimage.jpg", $this->cheminracine."antivolimage.jpg");
		@copy($this->cheminracine."modules/".$this->name."/img/stophacking.png", $this->cheminracine."stophacking.png");
		@copy($this->cheminracine."modules/".$this->name."/bannedvisitor.html", $this->cheminracine."bannedvisitor.html");
		//
		return true;
	}

	public function uninstall()
	{
		if (!Configuration::deleteByName('PMS_AdmFolder') OR !Configuration::deleteByName('PMS_BanList') OR !parent::uninstall())
			return false;
		@unlink($this->cheminracine."antivolimage.jpg");
		@unlink($this->cheminracine."stophacking.png");
		@unlink($this->cheminracine."bannedvisitor.html");

		return true;
	}
	
	public function getContent()
	{
		$output = '<h2>Protect My Shop</h2>';
		// Gestion SQLInjectionProtection
		if (Tools::isSubmit('submitPMSRSQL'))
		{
			Configuration::updateValue('PMS_SQLINJECT',false);
			$output .= '
				<div class="conf confirm">
				<img src="../img/admin/ok.gif" alt="" title="" />
				'.$this->l('Settings updated').'
			</div>';
		}
		if (Tools::isSubmit('submitPMSASQL'))
		{
			Configuration::updateValue('PMS_SQLINJECT',true);
			$output .= '
				<div class="conf confirm">
				<img src="../img/admin/ok.gif" alt="" title="" />
				'.$this->l('Settings updated').'
			</div>';
		}		
		// Gestion BanIP
		if (Tools::isSubmit('submitPMSAddBanIp'))
		{
			if(!($ip2ban = Tools::getValue('PMS_IP2BAN')))
			{
				$output .= '
				<div class="warn">
					<img src="../img/admin/warning.gif" alt="" title="" />
					'.$this->l('Please, input an Ip to add to the Ban List Filter.').'
				</div>';
			}else{
				Configuration::updateValue('PMS_BanList', $this->banlist.$ip2ban.";");
				$output .= '
					<div class="conf confirm">
					<img src="../img/admin/ok.gif" alt="" title="" />
					'.$this->l('Settings updated').'
				</div>';				
			}
		}		
		if (Tools::isSubmit('submitPMSRemoveBanIp'))
		{
			if(!($banip = Tools::getValue('PMS_BANIP')))
			{
				$output .= '
				<div class="warn">
					<img src="../img/admin/warning.gif" alt="" title="" />
					'.$this->l('Please, select an Ip to remove from Ban List Filter.').'
				</div>';
			}else{
				Configuration::updateValue('PMS_BanList', str_replace($banip.";","",$this->banlist));
				$output .= '
					<div class="conf confirm">
					<img src="../img/admin/ok.gif" alt="" title="" />
					'.$this->l('Settings updated').'
				</div>';				
			}
		}
		// Gestion du .htaccess Admin
		if (Tools::isSubmit('submitPMSRAdmin'))
		{
			if (!unlink($this->cheminracine.$this->admfolder."/.htaccess"))
			{
				$output .= '
				<div class="warn">
					<img src="../img/admin/warning.gif" alt="" title="" />
					'.$this->l('Please, change chmod to 777 on .htaccess temporary in order to unactive setting.').'
				</div>';
			}else{	
				$output .= '
					<div class="conf confirm">
					<img src="../img/admin/ok.gif" alt="" title="" />
					'.$this->l('Settings updated').'
				</div>';
				$this->protectadmin = false;
			}
		}
		if (Tools::isSubmit('submitPMSAAdmin'))
		{
			if (!$fp = fopen($this->cheminracine.$this->admfolder."/.htaccess",'wb')) 
			{
				$output .= '
				<div class="warn">
					<img src="../img/admin/warning.gif" alt="" title="" />
					'.$this->l('Please, change chmod to 777 on .htaccess temporary in order to update it.').'
				</div>';
			}else{
				fwrite($fp,"AuthName \"Admin Section\"\n");
				fwrite($fp,"AuthType Basic\n");
				fwrite($fp,"AuthUserFile \"".$this->cheminracine.$this->admfolder."/.password\"\n");
				fwrite($fp,"Require valid-user\n");
				//fwrite($fp,"ErrorDocument 401 /");
				fclose($fp); // On ferme le fichier
				$output .= '
				<div class="conf confirm">
				<img src="../img/admin/ok.gif" alt="" title="" />
				'.$this->l('Settings updated').'
				</div>';
			}
		}
		if (Tools::isSubmit('submitPMSAddUser') || Tools::isSubmit('submitPMSRemoveUser'))
		{
			if (Tools::getValue('PMS_NBU') == '1' && Tools::isSubmit('submitPMSRemoveUser') && $this->protectadmin)
			{
				$output .= '
				<div class="warn">
					<img src="../img/admin/warning.gif" alt="" title="" />
					'.$this->l('You have to keep at least one user if the Admin Section Protection is active. Unactive it first.').'
				</div>';
			}else{
				if (!$fp = fopen($this->cheminracine.$this->admfolder."/.password",'wb')) 
				{
					$output .= '
					<div class="warn">
						<img src="../img/admin/warning.gif" alt="" title="" />
						'.$this->l('Please, change chmod to 777 on .password temporary in order to update it.').'
					</div>';
				}else{
					$lastwritten = "";
					for($i=0;$i<$this->passwordnbline;$i++)
					{
						// On crit le fichier prcdent
						$update = true;
						if(Tools::isSubmit('submitPMSRemoveUser') && (!(strstr($this->adminpasswd[$i], Tools::getValue('PMS_USERS')) == false)))
							$update = false;
						if(($this->htaccessdata[$i] == $lastwritten) && $lastwritten == "\n")
							$update = false;
						if($update)
							{fwrite($fp,$this->adminpasswd[$i]);$lastwritten=$this->adminpasswd[$i];}
					}
					// On ajoute les nouveaux utilisateurs
					if(Tools::isSubmit('submitPMSAddUser')) 
					{
						if(($pms_login = Tools::getValue('PMS_LOGIN')) && ($pms_password = Tools::getValue('PMS_PWD')))
						{
							if(Tools::getValue('PMS_CRYPT') == 'Crypt')
							{
								fwrite($fp,$pms_login.':'.$this->crypt_apr1_md5($pms_password,$this->generate_salt(8))."\n");
							}else{
								fwrite($fp,$pms_login.':'.$pms_password."\n");
							}
						}else{
							$output .= '
							<div class="warn">
							<img src="../img/admin/warning.gif" alt="" title="" />
							'.$this->l('Please, input login and password').'
							</div>';
						}
					}
					fclose($fp); // On ferme le fichier
					
					if(filesize($this->cheminracine.$this->admfolder."/.password") == 0)
						@unlink($this->cheminracine.$this->admfolder."/.htaccess");
						
					$output .= '
					<div class="conf confirm">
					<img src="../img/admin/ok.gif" alt="" title="" />
					'.$this->l('Settings updated').'
					</div>';
				}
				
			}
		}
		// Gestion du .htaccess
		if (Tools::isSubmit('submitPMSAScript') || Tools::isSubmit('submitPMSAImg') || Tools::isSubmit('submitPMSAThemes') || Tools::isSubmit('submitPMSAFolders') || Tools::isSubmit('submitPMSRScript') || Tools::isSubmit('submitPMSRImg') || Tools::isSubmit('submitPMSRThemes') || Tools::isSubmit('submitPMSRFolders'))
		{
			if(!file_exists($this->cheminracine.".htaccess"))
			{
				$output .= '
				<div class="warn">
					<img src="../img/admin/warning.gif" alt="" title="" />
					'.$this->l('Please, generate your .htaccess file before.').'
				</div>';
			}else{
				// On crit le contenu du .htaccess
				if (!$fp = fopen($this->cheminracine.'.htaccess','wb')) {
					$output .= '
					<div class="warn">
					<img src="../img/admin/warning.gif" alt="" title="" />
					'.$this->l('Please, change chmod to 777 on .htacces temporary in order to update it.').'</div>';
				}else{
					$i=0;
					$lastwritten = "";
					for($i=0;$i<$this->htaccessnbline;$i++)
					{
						// On crit le fichier prcdent
						$update = true;
						if(Tools::isSubmit('submitPMSRScript') && (!(strstr($this->htaccessdata[$i], "RewriteCond %{HTTP_REFERER} ^$ [OR] #Script") == false) || !(strstr($this->htaccessdata[$i], "RewriteCond %{HTTP_REFERER} !^http://(www.)?".$_SERVER['SERVER_NAME']."(/)?.*$ [NC] #Script") == false) || !(strstr($this->htaccessdata[$i], "RewriteCond %{REQUEST_URI} ^.*\.(js|css)$ [NC]") == false) || !(strstr($this->htaccessdata[$i], "RewriteRule ^.*$   -   [F]") == false)))
							{$update = false;$this->protectscripts = false;}
						if(Tools::isSubmit('submitPMSRImg') && (!(strstr($this->htaccessdata[$i], "RewriteCond %{HTTP_REFERER} ^$ [OR] #Img") == false) || !(strstr($this->htaccessdata[$i], "RewriteCond %{HTTP_REFERER} !^http://(www.)?".$_SERVER['SERVER_NAME']."(/)?.*$ [NC] #Img") == false) || !(strstr($this->htaccessdata[$i], "RewriteCond %{HTTP_REFERER} !^http://(www.)?google?.*$ [NC]") == false) || !(strstr($this->htaccessdata[$i], "RewriteRule \.(gif|jpe?g|swf|flv|png|bmp)$ antivolimage.jpg [L,NC]") == false)))
							{$update = false;$this->protectimg = false;}
						if(Tools::isSubmit('submitPMSRThemes') && (!(strstr($this->htaccessdata[$i], "<FilesMatch \"\.tpl$\">") == false) || !(strstr($this->htaccessdata[$i], "order deny,allow") == false) || !(strstr($this->htaccessdata[$i], "deny from all") == false) || !(strstr($this->htaccessdata[$i], "</FilesMatch>") == false)))
							{$update = false;$this->protectthemes = false;}
						if(Tools::isSubmit('submitPMSRFolders') && !(strstr($this->htaccessdata[$i], "Options -Indexes") == false))
							{$update = false;$this->protectfolders = false;}
						if(($this->htaccessdata[$i] == $lastwritten) && $lastwritten == "\n")
							$update = false;
						if($update)
							{fwrite($fp,$this->htaccessdata[$i]);$lastwritten=$this->htaccessdata[$i];}
					}
					// On ajoute le script concern
					if(Tools::isSubmit('submitPMSAScript'))
					{
						fwrite($fp,"\nRewriteCond %{HTTP_REFERER} ^$ [OR] #Script\n");
						fwrite($fp,"RewriteCond %{HTTP_REFERER} !^http://(www.)?".$_SERVER['SERVER_NAME']."(/)?.*$ [NC] #Script\n");
						fwrite($fp,"RewriteCond %{REQUEST_URI} ^.*\.(js|css)$ [NC]\n");
						fwrite($fp,"RewriteRule ^.*$   -   [F]\n");
						$this->protectscripts = true;
					}
					if(Tools::isSubmit('submitPMSAImg'))
					{
						fwrite($fp,"\nRewriteCond %{HTTP_REFERER} ^$ [OR] #Img\n");
						fwrite($fp,"RewriteCond %{HTTP_REFERER} !^http://(www.)?".$_SERVER['SERVER_NAME']."(/)?.*$ [NC] #Img\n");
						fwrite($fp,"RewriteCond %{HTTP_REFERER} !^http://(www.)?google?.*$ [NC]\n");
						fwrite($fp,"RewriteRule \.(gif|jpe?g|swf|flv|png|bmp)$ antivolimage.jpg [L,NC]\n");
						$this->protectimg = true;
					}
					if(Tools::isSubmit('submitPMSAThemes'))
					{
						fwrite($fp,"\n<FilesMatch \"\.tpl$\">\n");
						fwrite($fp,"order deny,allow\n");
						fwrite($fp,"deny from all\n");
						fwrite($fp,"</FilesMatch>\n");
						$this->protectthemes = true;
					}
					if(Tools::isSubmit('submitPMSAFolders'))
					{
						fwrite($fp,"\nOptions -Indexes\n");
						$this->protectfolders = true;
					}
					
					fclose($fp); // On ferme le fichier
					
					$output .= '
					<div class="conf confirm">
					<img src="../img/admin/ok.gif" alt="" title="" />
					'.$this->l('Settings updated').'
					</div>';
				}
			}
		}
		$this->refreshSettings();
		return $output.$this->displayForm();	
	}

	public function displayForm()
	{
		$output = '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset class="space">
				<legend><img src="../img/admin/cog.gif" alt="" class="middle" />'.$this->l('Settings').'</legend>
				<fieldset class="space">';
				// htaccess File
				if($this->htaccessexist == false OR $this->htaccesschmod == false)
				{
					$output .= '<legend><img src="../img/admin/warning.gif" alt="" class="middle" />'.$this->l('htaccess File Protection').'</legend>';
					if($this->htaccessexist)
					{
						$output .= '<p style="color:red;">'.$this->l('Your htaccess File exists but have a too high permission flag. Use chmod to put it to 0404').'</p>';
					}else{
						$output .= '<p style="color:red;">'.$this->l('You don\'t have an htaccess file. Please generate one before continue').'</p>';
					}		
				}else{
					$output .= '<legend><img src="../img/admin/ok.gif" alt="" class="middle" />'.$this->l('htaccess File Protection').'</legend><p>'.$this->l('htaccess File exists and is correctly protected. Warning You will NOT be able to update settings until you restore it TEMPORARY to 777').'</p>';
				}
				$output .= '</fieldset><fieldset class="space">';
				// Admin Section Protection
				if($this->protectadmin == false)
				{
					$output .= '<legend><img src="../img/admin/warning.gif" alt="" class="middle" />'.$this->l('Admin Section Protection').'</legend>';
					$output .= '<p style="color:red;">'.$this->l('Your Admin Section is not enough protected. Add at least one user then active it').'</p>';
					if ($this->passwordnbline != 0)
					{
						$output .= '<BR/><center><input type="submit" name="submitPMSAAdmin" value="'.$this->l('Active this Setting').'" class="button" /></center>';
					}
				}else{
					$output .= '<legend><img src="../img/admin/ok.gif" alt="" class="middle" />'.$this->l('Admin Section Protection').'</legend><p>'.$this->l('Your Admin Section is correctly protected. Warning : Take care to keep always at least one user configured.').'</p><BR/><center><input type="submit" name="submitPMSRAdmin" value="'.$this->l('Unactive this Setting').'" class="button" /></center>';
				}
				$output .= '<BR/><center><fieldset class="width2">
				<label>'.$this->l('Login').' :</label>
				<div class="margin-form">
					<input type="text" name="PMS_LOGIN" value="'.Tools::getValue('PMS_LOGIN').'" />
				</div>
				<label>'.$this->l('Password').' :</label>
				<div class="margin-form">
					<input type="password" name="PMS_PWD" value="'.Tools::getValue('PMS_PWD').'" />
				</div>';
				if ($this->passwordnbline == 1)
					$output .='<input type="hidden" name="PMS_NBU" value="'.$this->passwordnbline.'" />';
				$output .='
				<div>
				<select name="PMS_USERS" style="width:350px;" size=5>';
				for ($i = 0; $i < $this->passwordnbline; $i++) 
				{
					$output .='<OPTION>'.$this->adminpasswd[$i];
				}
				$output .= '</select>
				</div>
				<input type="checkbox" name="PMS_CRYPT" value="Crypt"/> Crypt the password<BR/>(Warning some Web Servers don\'t like crypted passwords<br/><BR/>
				<center><input type="submit" name="submitPMSAddUser" value="'.$this->l('Add This User').'" class="button" /> - <input type="submit" name="submitPMSRemoveUser" value="'.$this->l('Remove This User').'" class="button" /></center>
				</fieldset></center>';
				$output .= '</fieldset>
				<fieldset class="space">';
				// SQL Injection Protection
				if($this->protectsql == false)
				{
					$output .= '<legend><img src="../img/admin/warning.gif" alt="" class="middle" />'.$this->l('SQL Inject Protection').'</legend>';
					$output .= '<p style="color:red;">'.$this->l('Your shop is not protected against SQL Injection Attacks. Please active this setting to protect you against hackers.').'</p><BR/><center><input type="submit" name="submitPMSASQL" value="'.$this->l('Active This Setting').'" class="button" /></center>';
				}else{
					$output .= '<legend><img src="../img/admin/ok.gif" alt="" class="middle" />'.$this->l('SQL Inject  Protection').'</legend><p>'.$this->l('Perfect your shop is correctly protected against SQL Injections.').'<p><BR/><center><input type="submit" name="submitPMSRSQL" value="'.$this->l('Unactive This Setting').'" class="button" /></center>';
				}
				$output .= '<BR/><center><fieldset class="width2">
				<label>'.$this->l('Ip To Ban').' :</label>
				<div class="margin-form">
					<input type="text" name="PMS_IP2BAN" value="'.Tools::getValue('PMS_IP2BAN').'" />
				</div>
				<div>
				<select name="PMS_BANIP" style="width:200px;" size=5>';
				for ($i = 0; $i < count($this->banlistarray)-1; $i++) 
				{
					$output .='<OPTION>'.$this->banlistarray[$i];
				}
				$output .= '</select>
				</div><BR/>
				<center><input type="submit" name="submitPMSAddBanIp" value="'.$this->l('Add This Ip').'" class="button" /> - <input type="submit" name="submitPMSRemoveBanIp" value="'.$this->l('Remove This Ip').'" class="button" /></center>
				</fieldset></center>';
				$output .= '</fieldset>
				<fieldset class="space">';
				// Folder Protection
				if($this->protectfolders == false)
				{
					$output .= '<legend><img src="../img/admin/warning.gif" alt="" class="middle" />'.$this->l('Folders Protection').'</legend>';
					$output .= '<p style="color:red;">'.$this->l('Your folders and subfolders are targatable.<BR/> For example : ').'<a href="http://'.$_SERVER['SERVER_NAME'].__PS_BASE_URI__.'modules/blockcategories/" target="_blank">'.$this->l('Click here for example').'</a><BR/><BR/>'.$this->l('This example is not a critical case, but some others could be.').'</p><center><input type="submit" name="submitPMSAFolders" value="'.$this->l('Active This Setting').'" class="button" /></center>';
				}else{
					$output .= '<legend><img src="../img/admin/ok.gif" alt="" class="middle" />'.$this->l('Folders Protection').'</legend><p>'.$this->l('Perfect your folders are correctly protected.').'</p><center><input type="submit" name="submitPMSRFolders" value="'.$this->l('Unactive This Setting').'" class="button" /></center>';
				}
				$output .= '</fieldset>
				<fieldset class="space">';
				// Themes Protection
				if($this->protectthemes == false)
				{
					$output .= '<legend><img src="../img/admin/warning.gif" alt="" class="middle" />'.$this->l('Themes Protection').'</legend>';
					$output .= '<p style="color:red;">'.$this->l('Your tpl files from templates are downloadable.<BR/> For example : ').'<a href="http://'.$_SERVER['SERVER_NAME'].__PS_BASE_URI__.'themes/prestashop/category.tpl" target="_blank">'.$this->l('Click here for example').'</a><BR/><BR/>'.$this->l('This example is base on the default theme, but could be adapted to any other template.').'</p><center><input type="submit" name="submitPMSAThemes" value="'.$this->l('Active This Setting').'" class="button" /></center>';
				}else{
					$output .= '<legend><img src="../img/admin/ok.gif" alt="" class="middle" />'.$this->l('Themes Protection').'</legend><p>'.$this->l('Perfect your templates are correctly protected.').'<p><center><input type="submit" name="submitPMSRThemes" value="'.$this->l('Unactive This Setting').'" class="button" /></center>';
				}
				$output .= '</fieldset>
				<fieldset class="space">';
				// Pictures Protection
				if($this->protectimg == false)
				{
					$output .= '<legend><img src="../img/admin/warning.gif" alt="" class="middle" />'.$this->l('Pictures Protection').'</legend>';
					$output .= '<p style="color:red;">'.$this->l('Your pictures are sharable. So others website can use your bandwidth to display your pictures on their websites.<BR/> For example copy/paste the following link into a new IE/Firefox/Chrome page: ').'http://'.$_SERVER['SERVER_NAME'].__PS_BASE_URI__.'img/logo.jpg<BR/><BR/>'.$this->l('This example is based on the logo, but could be adapted to any other pictures.').'</p><center><input type="submit" name="submitPMSAImg" value="'.$this->l('Active This Setting').'" class="button" /></center>';
				}else{
					$output .= '<legend><img src="../img/admin/ok.gif" alt="" class="middle" />'.$this->l('Pictures Protection').'</legend><p>'.$this->l('Perfect your pictures and bandwidth are correctly protected.').'<p><center><input type="submit" name="submitPMSRImg" value="'.$this->l('Unactive This Setting').'" class="button" /></center>';
				}
				$output .= '</fieldset>
				<fieldset class="space">';
				// Scripts Protection
				if($this->protectscripts == false)
				{
					$output .= '<legend><img src="../img/admin/warning.gif" alt="" class="middle" />'.$this->l('Scripts Protection').'</legend>';
					$output .= '<p style="color:red;">'.$this->l('Your Script & CSS files are downloadable.<BR/> For example copy/paste the following link into a new IE/Firefox/Chrome page: ').'http://'.$_SERVER['SERVER_NAME'].__PS_BASE_URI__.'themes/prestashop/js/product.js<BR/><BR/>'.$this->l('This example is based on the default theme, but could be adapted to any other scripts used by templates and/or modules.').'</p><center><input type="submit" name="submitPMSAScript" value="'.$this->l('Active This Setting').'" class="button" /></center>';
				}else{
					$output .= '<legend><img src="../img/admin/ok.gif" alt="" class="middle" />'.$this->l('Scripts Protection').'</legend><p>'.$this->l('Perfect your scripts and CSS are correctly protected.').'<BR/><BR/>'.$this->l('Please note that CSS and JavaScript are code interpreted by the Navigator. So Thiefs will always be able to copy the code by an another way, but they will not be able to download it directly anymore.').'<p><center><input type="submit" name="submitPMSRScript" value="'.$this->l('Unactive This Setting').'" class="button" /></center>';
				}
				$output .= '</fieldset>
								<fieldset class="space">';
				// Useless Files Protection
				if($this->protectfiles == false)
				{
					$output .= '<legend><img src="../img/admin/warning.gif" alt="" class="middle" />'.$this->l('Useless Files Protection').'</legend>';
					$output .= '<p style="color:red;">'.$this->l('We recommand you to delete the followings folders and files. Indeed, with for example the file CHANGELOG, a hacker could know under which version of prestashop you\'re running.').'
					<BR/><center>docs<BR/>readme_fr.txt<BR/>readme_en.txt<BR/>readme_es.txt<BR/>readme_de.txt<BR/>readme_it.txt<BR/>CHANGELOG<BR/>';
				}else{
					$output .= '<legend><img src="../img/admin/ok.gif" alt="" class="middle" />'.$this->l('Useless Files Protection').'</legend><p>'.$this->l('Perfect you don\'t have any useless file that could be potentialy dangerous.');
				}
				$output .= '</fieldset>
			</fieldset>
		</form>';
		
		$output .= '
		<fieldset class="space">
			<legend><img src="../img/admin/unknown.gif" alt="" class="middle" />'.$this->l('Help').'</legend>
			 <h3>'.$this->l('Protect My Shop Module').'</h3>
			 '.$this->l('Your shop protection has no price. Protect My Shop Module is the better protection module ever developped for prestashop :').'
			 <ol>
			 	<li>'.$this->l('The htaccess protection warn you if the permission of the file is too high.').'</li>
				<li>'.$this->l('The Admin Section Protection adds an additionnal protection to your Administration section.').'</li>
			 	<li>'.$this->l('The SQL Injection Protection protects you against SQL Injection Code through the URL or any Forms on your shop.').'</li>
				<li>'.$this->l('The Folders Protection protects all your sub-folders against unauthorised acces.').'</li>
				<li>'.$this->l('The Themes Protection protects your themes from stealing. (.tpl Files).').'</li>
				<li>'.$this->l('The Pictures Protection protects you against bandwidth thiefs.').'</li>
			 	<li>'.$this->l('The Scripts Protection protects you against direct download of your .css and .js Files.').'</li>
				<li>'.$this->l('The Useless Files Protection protects you against hackers who try to get some informations on your configuration.').'</li>
			</ol>
			<BR/>
			'.$this->l('This module is compatible ALL versions of prestashop.').'
			<BR/><BR/><BR/>'.$this->l('For support please feel free to contact us on our forum at ').'<a href="http://www.librasoft.fr/forum/" target="_blank">http://www.librasoft.fr/forum/</a>
			<BR/><BR/><a href="http://www.librasoft.fr/" target="_blank"><img src="../modules/'.$this->name.'/LibraSoftLogoModule.png" alt="Librasoft"></a><BR/>Copyright 2011 Librasoft.
		</fieldset>';
		return $output;
	}

	public function hookHeader($params)
	{
		global $smarty, $protocol_content;
		if($this->protectsql == true)
		{
			// Vrification Filtre Ban
			$banip = $this->get_ip();
			if (!(strstr($this->banlist,$banip) == false))
			{
				header('location: /bannedvisitor.html'); // page de ban
				die(); 
			}
			$issqlinject = false;
			$url = $_SERVER["REQUEST_URI"];
			// Vrification URL GET
			if (
				(preg_match("#<[^>]*\w*\"?[^>]*>#is",$url)) ||
				(preg_match("#\Wcmd=?\b#is",$url)) ||
				(preg_match("#execu?\\b#is",$url)) ||
				(preg_match("#[\d\W](union|insert|from|where|concat|into|cast)[\d\W]#is",$url)) ||
				(preg_match("#http:\/\/.*#is",$url)) ||
				(preg_match("#https:\/\/.*#is",$url)) ||
				(preg_match("#\.\/#i",$url)))
					$issqlinject = true;
			// Vrification URL POST
			foreach ($_POST as $check_form) 
			{
				if (
					(preg_match("#<[^>]*script*\"?[^>]*>#is", $check_form)) ||
					(preg_match("#<[^>]*object*\"?[^>]*>#is", $check_form)) ||
					(preg_match("#<[^>]*iframe*\"?[^>]*>#is", $check_form)) ||
					(preg_match("#<[^>]*applet*\"?[^>]*>#is", $check_form)) ||
					(preg_match("#<[^>]*body*\"?[^>]*>#is", $check_form)
					&&!preg_match("#<[^>]*tbody*\"?[^>]*>#is", $check_form)) ||
					(preg_match("#<[^>]*onmouseover*\"?[^>]*#is", $check_form)) ||
					(preg_match("#<[^>]*img*\"?[^>]*#is", $check_form)) ||
					(preg_match("#<[^>]*meta*\"?[^>]*>#is", $check_form)) ||
					(preg_match("#<[^>]*style*\"?[^>]*>#is", $check_form)))
						$issqlinject = true;
			}
			// S'il s'agit d'une attaque
			if ($issqlinject)
			{
				// Envoi du mail d'alerte
				$mail_expediteur = "noreply@".$_SERVER['HTTP_HOST'];
				$mailheaders = "From: ".$mail_expediteur . "\r\n";
				$msg = $this->l('An attack on your shop')." ".$_SERVER['HTTP_HOST']." ".$this->l('by')." ".$banip." ".$this->l('through')." ".$_SERVER['REQUEST_URI']." ".$this->l('has been stopped')."\n\n";
				$msg .= "HTTP_SERVER_VARS:\n\n";
				$msg .= "HTTP_HOST_NAME => ".gethostbyaddr($banip)."\n\n";
				while (list ($key, $val) = each ($_SERVER)) $msg .= "$key => $val\n";
				$msg = addslashes($msg);
				eval("\$msg = \"$msg\";");
				$msg = stripslashes($msg); 			 
				@mail(Configuration::get('PS_SHOP_EMAIL'),'HACKING REPORT '.$banip,$msg,$mailheaders);				
				unset($check_form); 
				// Ajout de l'ip au filtre ban
				Configuration::updateValue('PMS_BanList', $this->banlist.$banip.";");
				// Redirection vers die
				$iphack = "http://www.who.is/whois-ip/ip-address/".$banip;
				die('<html><head><title>Stop Hacking Us</title><SCRIPT language="Javascript">alert("Hacking Protect :\n\nUnauthorized access was detected from your IP. You are banned !\nAcc\350s interdit d\351tect\351 depuis votre IP. Vous \352tes banni !");</SCRIPT></head><body style=margin:0px;><div align="center" style="background-color:#000000;"><br /><br /><font size="+6"><b><span style="color: #FFFFFF">Stop hacking Us</span></b></font><br /><br /><img src="stophacking.png" border="0"><br /><br /><br /><br /></div></body></html>');
			}
		}
		return $this->display(__FILE__, 'header.tpl');
	}
	
	private function crypt_apr1_md5($plain,$salt)
	{
		$length = strlen($plain); 
		$context = $plain . '$apr1$' . $salt; 
		$binary = pack('H32', md5($plain . $salt . $plain)); 
		for($i = $length; $i > 0; $i -= 16) { 
			$context .= substr($binary, 0, min(16, $i)); 
		} 
		for($i = $length; $i > 0; $i >>= 1) { 
			$context .= ($i & 1) ? chr(0) : $plain{0}; 
		} 
		$binary = pack('H32', md5($context)); 
		for($i = 0; $i < 1000; $i++) { 
			$new = ($i & 1) ? $plain : $binary; 
			if ($i % 3) $new .= $salt; 
			if ($i % 7) $new .= $plain; 
			$new .= ($i & 1) ? $binary : $plain; 
			$binary = pack('H32', md5($new)); 
		} 
		$q = ''; 
		for ($i = 0; $i < 5; $i++) { 
			$k = $i + 6; 
			$j = $i + 12; 
			if ($j == 16) $j = 5; 
			$q = $binary{$i} . $binary{$k} . $binary{$j} . $q; 
		} 
		$q = chr(0) . chr(0) . $binary{11} . $q; 
		$q = strtr(strrev(substr(base64_encode($q), 2)), 
                'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/',
                 './0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz');
		return "\$apr1\$$salt\$$q"; 
	}
	
	private function generate_salt($len) { 
		$randset = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
		$randset .= './0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
		$salt = ""; 
		for ($i=0;$i<$len;$i++) { 
			$choice = rand(0,strlen($randset)-1); 
			$salt .= (substr($randset,$choice,1)); 
		} 
		return $salt; 
	}
	
	function get_ip(){
		if(isset($_SERVER['HTTP_X_FORWARDED_FOR'])){
		$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];}
		elseif(isset($_SERVER['HTTP_CLIENT_IP'])){
		$ip = $_SERVER['HTTP_CLIENT_IP'];}
		else { $ip = $_SERVER['REMOTE_ADDR'];}
		return $ip;
	} 
}