<?php

class LeftEditorial extends Module
{
	/** @var max image size */
	protected $maxImageSize = 307200;

	function __construct()
	{
		$this->name = 'lefteditorial';
		$this->tab = 'Wizard Workz';
		$this->version = '1.4';
		
		parent::__construct();
		
		$this->displayName = $this->l('Left text editor');
		$this->description = $this->l('A text editor module for your left column');
	}

	function install()
	{
		if (!parent::install())
			return false;
		// Trunk file if already exists with contents
		/*
		if (!$fd = @fopen(dirname(__FILE__).'/lefteditorial.xml', 'w'))
			return false;
		@fclose($fd);
		*/
		return $this->registerHook('leftColumn');
	}

	function putContent($xml_data, $key, $field, $forbidden, $section)
	{
		foreach ($forbidden AS $line)
			if ($key == $line)
				return 0;
		if (!eregi('^'.$section.'_', $key))
			return 0;
		$key = eregi_replace('^'.$section.'_', '', $key);
		//$field = pSQL($field);
		$field = htmlspecialchars($field);
		if (!$field)
			return 0;
		return ("\n".'		<'.$key.'>'.$field.'</'.$key.'>');
	}

	function getContent()
	{
		/* display the module name */
		$this->_html = '<h2>'.$this->displayName.'</h2>';

		/* update the lefteditorial xml */
		if (isset($_POST['submitUpdate']))
		{
			// Forbidden key
			$forbidden = array('submitUpdate');
			
			foreach ($_POST AS $key => $value)
				if (!Validate::isCleanHtml($_POST[$key]))
				{
					$this->_html .= $this->displayError($this->l('Invalid html field, javascript is forbidden'));
					$this->_displayForm();
					return $this->_html;
				}

			// Generate new XML data
			$newXml = '<?xml version=\'1.0\' encoding=\'utf-8\' ?>'."\n";
			$newXml .= '<lefteditorial>'."\n";
			$newXml .= '	<header>';
			// Making header data
			foreach ($_POST AS $key => $field)
				if ($line = $this->putContent($newXml, $key, $field, $forbidden, 'header'))
					$newXml .= $line;
			$newXml .= "\n".'	</header>'."\n";
			$newXml .= '	<body>';
			// Making body data
			foreach ($_POST AS $key => $field)
				if ($line = $this->putContent($newXml, $key, $field, $forbidden, 'body'))
					$newXml .= $line;
			$newXml .= "\n".'	</body>'."\n";
			$newXml .= '</lefteditorial>'."\n";

			/* write it into the lefteditorial xml file */
			if ($fd = @fopen(dirname(__FILE__).'/lefteditorial.xml', 'w'))
			{
				if (!@fwrite($fd, $newXml))
					$this->_html .= $this->displayError($this->l('Unable to write to the editor file.'));
				if (!@fclose($fd))
					$this->_html .= $this->displayError($this->l('Can\'t close the editor file.'));
			}
			else
				$this->_html .= $this->displayError($this->l('Unable to update the editor file.<br />Please check the editor file\'s writing permissions.'));

		}

		/* display the lefteditorial's form */
		$this->_displayForm();
	
		return $this->_html;
	}

	private function _displayForm()
	{
		global $cookie;
		
		/* Languages preliminaries */
		$defaultLanguage = intval(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		$iso = Language::getIsoById($defaultLanguage);
		$divLangName = 'cpara';

		/* xml loading */
		$xml = false;
		if (file_exists(dirname(__FILE__).'/lefteditorial.xml'))
				if (!$xml = @simplexml_load_file(dirname(__FILE__).'/lefteditorial.xml'))
					$this->_html .= $this->displayError($this->l('Your editor file is empty.'));

		$this->_html .= '<br />
			<script type="text/javascript" src="../js/tinymce/jscripts/tiny_mce/tiny_mce.js"></script>
			<script language="javascript" type="text/javascript">
				tinyMCE.init({
					language : "';
		$iso = Language::getIsoById(intval($cookie->id_lang));
		$this->_html .= ((!file_exists(PS_ADMIN_DIR.'/../js/tinymce/jscripts/tiny_mce/langs/'.$iso.'.js')) ? 'en' : $iso).'",
					mode : "textareas",
					elements : "nourlconvert",
					convert_urls : false,
					theme : "advanced",
					theme_advanced_buttons1 : "bold, italic, underline, fontselect, fontsizeselect",
					theme_advanced_buttons2 : "forecolor, backcolor, separator, justifyleft, justifycenter, justifyright, justifyfull, separator, bullist, numlist, separator, undo, redo, separator, link, unlink, separator, code",
					theme_advanced_buttons3 : "",
					theme_advanced_toolbar_location : "top",
					theme_advanced_toolbar_align : "left",
					plugins : "contextmenu, directionality, media, paste, preview, safari",
					theme_advanced_buttons3_add : "ltr,rtl,pastetext,pasteword,selectall",
					theme_advanced_buttons1_add : "media,preview",
					paste_create_paragraphs : false,
					paste_create_linebreaks : false,
					paste_use_dialog : true,
					paste_auto_cleanup_on_paste : true,
					paste_convert_middot_lists : false,
					paste_unindented_list_class : "unindentedList",
					paste_convert_headers_to_strong : true,
					paste_insert_word_content_callback : "convertWord",
					plugin_preview_width : "500",
					plugin_preview_height : "800",
					extended_valid_elements : "a[name|href|target|title|onclick],img[class|src|border=0|alt|title|hspace|vspace|width|height|align|onmouseover|onmouseout|name],hr[class|width|size|noshade],font[face|size|color|style],span[class|align|style]"
				});
				function convertWord(type, content)
				{
					switch (type)
					{
						case "before":
							break;
						case "after":
							break;
					}
					return content;
				}
		</script>
		<script language="javascript">id_language = Number('.$defaultLanguage.');</script>
		<form method="post" action="'.$_SERVER['REQUEST_URI'].'" enctype="multipart/form-data">
			<fieldset style="width: 900px;">
				<legend><img src="'.$this->_path.'logo.gif" alt="" title="" /> '.$this->displayName.'</legend>
				
<div class="margin-form">		
<ul>
<li>'.$this->l('This is a small version of the Editorial Module for Right Column.').'</li>
<li>'.$this->l('Important!  your media or images should not be more than 174px width').'</li>
<li>'.$this->l('For single block use just add your code at the editor').'</li>
<li>'.$this->l('For multiple blocks use sample at bottom and also change code on file lefteditorial.php or righteditorial.php around line 234 ').'</li>
<li>'.$this->l('Change this: lefteditorial.tpl or righteditorial.tpl').'</li>
<li>'.$this->l('For this: blanklefteditorial.tpl or blankrighteditorial.tpl').'</li>
<li></li>
<li style="color:#FF0000;">'.$this->l('
&lt;div id=&quot;righteditor_block_right&quot; class=&quot;block&quot;&gt;<br>
&lt;h4&gt;TITLE 1&lt;/h4&gt;<br>
&lt;div class=&quot;block_content&quot;&gt;CONTENT 1 GOES HERE&lt;/div&gt;<br>
&lt;/div&gt;
').'</li>
<li></li>
<li style="color:#FF0000;">'.$this->l('
&lt;div id=&quot;righteditor_block_right&quot; class=&quot;block&quot;&gt;<br>
&lt;h4&gt;TITLE 2&lt;/h4&gt;<br>
&lt;div class=&quot;block_content&quot;&gt;CONTENT 2 GOES HERE&lt;/div&gt;<br>
&lt;/div&gt;
').'</li>
<li></li>
<li style="color:#FF0000;">'.$this->l('
&lt;div id=&quot;righteditor_block_right&quot; class=&quot;block&quot;&gt;<br>
&lt;h4&gt;TITLE 3&lt;/h4&gt;<br>
&lt;div class=&quot;block_content&quot;&gt;CONTENT 3 GOES HERE&lt;/div&gt;<br>
&lt;/div&gt;
').'</li>
<li></li>
</ul>
</div>


				<label>'.$this->l('Introductory text Top').'</label>
				<div class="margin-form">';

				foreach ($languages as $language)
				{
					$this->_html .= '
					<div id="cpara_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';float: left;">
						<textarea cols="100" rows="30" id="body_paragraph_'.$language['id_lang'].'" name="body_paragraph_'.$language['id_lang'].'">'.($xml ? stripslashes(htmlspecialchars($xml->body->{'paragraph_'.$language['id_lang']})) : '').'</textarea>
					</div>';
				 }
				
				$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangName, 'cpara', true);
				
				$this->_html .= '
					<p class="clear">'.$this->l('Text of your choice; for example, explain your mission, highlight a new product, or describe a recent event').'</p>


				<div class="clear pspace"></div>
				<div class="margin-form clear"><input type="submit" name="submitUpdate" value="'.$this->l('Update the editor').'" class="button" /></div>
			</fieldset>
		</form>';
	}

	function hookLeftColumn($params)
	{
		if (file_exists('modules/lefteditorial/lefteditorial.xml'))
		{
			if ($xml = simplexml_load_file('modules/lefteditorial/lefteditorial.xml'))
			{
				global $cookie, $smarty;
				$smarty->assign(array(
					'xml' => $xml,
					'paragraph' => 'paragraph_'.$cookie->id_lang,
					'this_path' => $this->_path
				));    /* For Multiple Blocks blanklefteditorial.tpl */ /* For Single Block lefteditorial.tpl */
				return $this->display(__FILE__, 'lefteditorial.tpl');  
			}
		}
		return false;
	}

}
