<?php

/**

 *  2016 ModuleFactory.co

 *

 *  @author    ModuleFactory.co <info@modulefactory.co>

 *  @copyright 2016 ModuleFactory.co

 *  @license   ModuleFactory.co Commercial License

 */



if (!defined('_PS_VERSION_')) {

    exit;

}



$class_folder = dirname(__FILE__).'/classes/';

require_once($class_folder.'FsAdConversionDataTransfer.php');

require_once($class_folder.'FsAdConversionMessenger.php');

require_once($class_folder.'FsAdConversionModel.php');

require_once($class_folder.'FsAdConversionTools.php');



class Fsadconversion extends Module

{

    private static $smarty_registered = false;



    public function __construct()

    {

        $this->name = 'fsadconversion';

        $this->tab = 'analytics_stats';

        $this->version = '1.2.0';

        $this->author = 'ModuleFactory';

        $this->need_instance = 0;

        $this->ps_versions_compliancy['min'] = '1.5';

        $this->module_key = 'd67b91e555da8a75af45a48ab13080d6';

        $this->bootstrap = true;



        parent::__construct();



        $this->displayName = $this->l('Google AdWords + Facebook Ads Conversion Tracking Codes');

        $this->description = $this->l(

            'Add multiple Google AdWords or Facebook Ad conversion tracking code to the order thank you page.'

        );



        $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');



        $this->ad_types = array(

            array('id' => 'google', 'name' => $this->l('Google AdWords')),

            array('id' => 'facebookpixel', 'name' => $this->l('Facebook Pixel')),

            array('id' => 'facebook', 'name' => $this->l('Facebook Conversion Tracking Pixel (Deprecated)')),

        );



        $this->price_calculation = array(

            array('id' => '1', 'name' => $this->l('Total products (Tax excl.)')),

            array('id' => '2', 'name' => $this->l('Total products (Tax incl.)')),

            array('id' => '3', 'name' => $this->l('Total products + Shipping (Tax excl.)')),

            array('id' => '4', 'name' => $this->l('Total products + Shipping (Tax incl.)')),

            array('id' => '5', 'name' => $this->l('Total products + Wrapping (Tax excl.)')),

            array('id' => '6', 'name' => $this->l('Total products + Wrapping (Tax incl.)')),

            array('id' => '7', 'name' => $this->l('Total products + Shipping + Wrapping (Tax excl.)')),

            array('id' => '8', 'name' => $this->l('Total products + Shipping + Wrapping (Tax incl.)')),

        );



        $this->ad_types_name = array();

        foreach ($this->ad_types as $ad_types) {

            $this->ad_types_name[$ad_types['id']] = $ad_types['name'];

        }



        if (!self::$smarty_registered) {

            $context = Context::getContext();

            smartyRegisterFunction(

                $context->smarty,

                'modifier',

                'fsacCorrectTheMess',

                array('FsAdConversionTools', 'unescapeSmarty'),

                false

            );

            smartyRegisterFunction(

                $context->smarty,

                'modifier',

                'fsacJsonEncode',

                array('Fsadconversion', 'jsonEncodeStatic'),

                false

            );

            smartyRegisterFunction(

                $context->smarty,

                'modifier',

                'fsacRemoveDpa',

                array($this, 'removeDpa'),

                false

            );

            self::$smarty_registered = true;

        }

    }



    public function url()

    {

        $context = Context::getContext();

        $url = $context->link->getAdminLink('AdminModules').'&configure='.$this->name;

        if ($this->isPsMin17()) {

            return $url;

        }

        return FsAdConversionTools::baseUrl().$url;

    }



    public function getModuleBaseUrl()

    {

        return $this->context->shop->getBaseURL().'modules/'.$this->name.'/';

    }



    public function getDocumentationUrl()

    {

        return $this->getModuleBaseUrl().'documentation.pdf';

    }



    public function getModuleFile()

    {

        return __FILE__;

    }



    public function install()

    {

        $return = parent::install();

        $return = $return && $this->registerHook('displayHeader');

        $return = $return && $this->registerHook('displayOrderConfirmation');

        $return = $return && $this->installDB();

        return $return;

    }



    public function installDB()

    {

        $return = Db::getInstance()->execute('

            CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'fsadconversion` (

                `id_fsadconversion` int unsigned NOT NULL AUTO_INCREMENT,

                `id_shop` int(10) unsigned NOT NULL,

                `type` varchar(100) NOT NULL,

                `conversion_id` varchar(100) NOT NULL,

                `conversion_label` varchar(100) NOT NULL,

                `price_calculation` tinyint(2) unsigned NOT NULL DEFAULT \'2\',

                `dpa` tinyint(1) unsigned NOT NULL DEFAULT \'0\',

                `active` tinyint(1) unsigned NOT NULL DEFAULT \'0\',

                `date_add` datetime NOT NULL,

                `date_upd` datetime NOT NULL,

                PRIMARY KEY (`id_fsadconversion`),

                KEY `id_shop` (`id_shop`),

                KEY `active` (`active`)

            ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8 ;');



        return $return;

    }



    public function uninstall()

    {

        $return = parent::uninstall();

        $return = $return && $this->uninstallDB();

        return $return;

    }



    public function uninstallDB()

    {

        return Db::getInstance()->execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'fsadconversion`');

    }



    #################### ADMIN ####################



    public function getContent()

    {

        $context = Context::getContext();

        $context->controller->addCSS(($this->_path).'views/css/admin.css', 'all');

        $context->controller->addJS(($this->_path).'views/js/admin.js');

        $html = $this->getCssAndJs();



        $html .= FsAdConversionMessenger::getMessagesHtml();



        if (Tools::isSubmit('save'.$this->name)) {

            $is_new = false;

            $id_fsadconversion = (int)Tools::getValue('id_fsadconversion');



            if ($id_fsadconversion) {

                $fsadconversion = new FsAdConversionModel((int)$id_fsadconversion);

            } else {

                $fsadconversion = new FsAdConversionModel();

                $is_new = true;

            }



            $fsadconversion->copyFromPost();

            $fsadconversion->id_shop = $this->context->shop->id;



            if ($fsadconversion->validateFields(false) && $fsadconversion->validateFieldsLang(false)) {

                $fsadconversion->save();

                if ($is_new) {

                    FsAdConversionMessenger::addSuccessMessage($this->l('Creation successful'));

                } else {

                    FsAdConversionMessenger::addSuccessMessage($this->l('Update successful'));

                }



                FsAdConversionTools::redirect($this->url().'&id_fsadconversion_validate='.$fsadconversion->id);

            } else {

                FsAdConversionDataTransfer::setData($_REQUEST);

                FsAdConversionMessenger::addErrorMessage($this->l('Please fill the required fields.'));

                FsAdConversionTools::redirectBack($this->url());

            }

        } elseif (Tools::isSubmit('add'.$this->name)) {

            $form_config = array('title' => $this->displayName.' > '.$this->l('New'));

            $helper = $this->initForm($form_config);



            $data_transfer = FsAdConversionDataTransfer::getData();



            if ($data_transfer) {

                $helper->fields_value['type'] = FsAdConversionTools::getValue('type', '', $data_transfer);

                $helper->fields_value['conversion_id'] =

                    FsAdConversionTools::getValue('conversion_id', '', $data_transfer);

                $helper->fields_value['conversion_label'] =

                    FsAdConversionTools::getValue('conversion_label', '', $data_transfer);

                $helper->fields_value['price_calculation'] =

                    FsAdConversionTools::getValue('price_calculation', '', $data_transfer);

                $helper->fields_value['dpa'] = FsAdConversionTools::getValue('dpa', 0, $data_transfer);

                $helper->fields_value['active'] = FsAdConversionTools::getValue('active', 1, $data_transfer);

            } else {

                $helper->fields_value['type'] = '';

                $helper->fields_value['conversion_id'] = '';

                $helper->fields_value['conversion_label'] = '';

                $helper->fields_value['price_calculation'] = 2;

                $helper->fields_value['dpa'] = 0;

                $helper->fields_value['active'] = 1;

            }



            $helper->title[] = $this->l('New');



            return $html.$helper->generateForm($this->fields_form);

        } elseif (Tools::isSubmit('update'.$this->name)) {

            $id_fsadconversion = (int)Tools::getValue('id_fsadconversion');

            $fsadconversion = new FsAdConversionModel((int)$id_fsadconversion);



            if (!$fsadconversion->id) {

                FsAdConversionMessenger::addErrorMessage($this->l('Object not found.'));

                FsAdConversionTools::redirectBack($this->url());

            }



            $form_config = array('title' => $this->displayName.' > '.$this->l('Edit'));

            $helper = $this->initForm($form_config);



            $data_transfer = FsAdConversionDataTransfer::getData();



            if ($data_transfer) {

                $helper->fields_value['type'] = FsAdConversionTools::getValue('type', '', $data_transfer);

                $helper->fields_value['conversion_id'] =

                    FsAdConversionTools::getValue('conversion_id', '', $data_transfer);

                $helper->fields_value['conversion_label'] =

                    FsAdConversionTools::getValue('conversion_label', '', $data_transfer);

                $helper->fields_value['price_calculation'] =

                    FsAdConversionTools::getValue('price_calculation', '', $data_transfer);

                $helper->fields_value['dpa'] = FsAdConversionTools::getValue('dpa', 0, $data_transfer);

                $helper->fields_value['active'] = FsAdConversionTools::getValue('active', 1, $data_transfer);

            } else {

                $helper->fields_value['type'] = $fsadconversion->type;

                $helper->fields_value['conversion_id'] = $fsadconversion->conversion_id;

                $helper->fields_value['conversion_label'] = $fsadconversion->conversion_label;

                $helper->fields_value['price_calculation'] = $fsadconversion->price_calculation;

                $helper->fields_value['dpa'] = $fsadconversion->dpa;

                $helper->fields_value['active'] = $fsadconversion->active;

            }



            $this->fields_form[0]['form']['input'][] = array('type' => 'hidden', 'name' => 'id_fsadconversion');

            $helper->fields_value['id_fsadconversion'] = (int)$id_fsadconversion;



            $helper->title[] = $this->l('Edit');



            return $html.$helper->generateForm($this->fields_form);

        } elseif (Tools::isSubmit('status'.$this->name)) {

            $id_fsadconversion = (int)Tools::getValue('id_fsadconversion');



            if ($id_fsadconversion) {

                $fsadconversion = new FsAdConversionModel((int)$id_fsadconversion);

                if ($fsadconversion->id) {

                    $fsadconversion->toggleStatus();

                }

            }



            FsAdConversionMessenger::addSuccessMessage($this->l('The status has been updated successfully.'));

            FsAdConversionTools::redirectBack($this->url());

        } elseif (Tools::isSubmit('delete'.$this->name)) {

            $id_fsadconversion = (int)Tools::getValue('id_fsadconversion');



            if ($id_fsadconversion) {

                $fsadconversion = new FsAdConversionModel((int)$id_fsadconversion);

                if ($fsadconversion->id) {

                    $fsadconversion->delete();

                }

            }



            FsAdConversionMessenger::addSuccessMessage($this->l('Deletion successful'));

            FsAdConversionTools::redirectBack($this->url());

        } else {

            $helper = $this->initList();



            $fsadconversion_pagination_default = 50;

            if ($this->isPs15()) {

                $fsadconversion_pagination_default = 20;

            }

            $filter = array(

                'id_fsadconversion' => Tools::getValue('fsadconversionFilter_id_fsadconversion', ''),

                'type' => Tools::getValue('fsadconversionFilter_type', ''),

                'conversion_id' => Tools::getValue('fsadconversionFilter_conversion_id', ''),

                'active' => Tools::getValue('fsadconversionFilter_active', ''),

                'page' => Tools::getValue('submitFilterfsadconversion', 1),

                'limit' => Tools::getValue('fsadconversion_pagination', $fsadconversion_pagination_default),

                'order_by' => Tools::getValue('fsadconversionOrderby', 'id_fsadconversion'),

                'order_way' => Tools::strtoupper(Tools::getValue('fsadconversionOrderway', 'DESC')),

            );



            if (!$filter['page']) {

                $filter['page'] = 1;

            }



            if (Tools::isSubmit('submitResetfsadconversion')) {

                $filter['id_fsadconversion'] = '';

                $filter['type'] = '';

                $filter['conversion_id'] = '';

                $filter['active'] = '';

                $filter['page'] = 1;

                $filter['limit'] = Tools::getValue('fsadconversion_pagination', $fsadconversion_pagination_default);

            }



            $this->context->cookie->fsadconversionFilter_id_fsadconversion = $filter['id_fsadconversion'];

            $this->context->cookie->fsadconversionFilter_type = $filter['type'];

            $this->context->cookie->fsadconversionFilter_conversion_id = $filter['conversion_id'];

            $this->context->cookie->fsadconversionFilter_active = $filter['active'];

            $this->context->cookie->fsadconversionOrderby = $filter['order_by'];

            //$this->context->cookie->fsadconversionOrderway = $filter['order_way'];



            $list_content = FsAdConversionModel::getListContent($filter);



            if ($list_content) {

                foreach ($list_content as $key => $row) {

                    $list_content[$key]['type'] = $this->ad_types_name[$row['type']];

                }



                $helper->listTotal = count($list_content);

            }



            $html .= $helper->generateList($list_content, $this->fields_list);



            $context->smarty->assign(array(

                'is_ps_15' => $this->isPs15(),

                'is_ps_min_16' => $this->isPsMin16(),

                'module_base_url' => $this->getModuleBaseUrl()

            ));



            $html .= $this->display(__FILE__, 'views/templates/admin/help.tpl');



            //Validate the code

            $id_fsadconversion_validate = (int)Tools::getValue('id_fsadconversion_validate', false);

            if ($id_fsadconversion_validate) {

                $fsadconversion_validate = new FsAdConversionModel($id_fsadconversion_validate);

                $this->context->smarty->assign(array(

                    'fsac' => $fsadconversion_validate

                ));

                $html .= $this->display($this->getModuleFile(), 'views/templates/admin/validate.tpl');

            }



            return $html;

        }

    }



    protected function initForm($config = false)

    {

        $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');



        $this->fields_form[0]['form'] = array();



        if ($this->isPsMin16()) {

            if ($config && isset($config['title'])) {

                $this->fields_form[0]['form']['legend'] = array('title' => $config['title']);

            }

        }



        $this->fields_form[0]['form']['input'] = array(

            array(

                'type' => 'select',

                'label' => $this->l('Type:'),

                'name' => 'type',

                'options' => array(

                    'query' => $this->ad_types,

                    'id' => 'id',

                    'name' => 'name',

                ),

                'desc' => $this->l('Select the advertising platform.'),

            ),

            array(

                'type' => 'text',

                'label' => $this->l('Conversion ID:'),

                'name' => 'conversion_id',

                'size' => 70,

                'required' => true,

                'desc' => '<a href="'.$this->getDocumentationUrl().'" target="_blank">'.

                    $this->l('Read the documentation where to find this.').'</a>',

            ),

            array(

                'type' => 'text',

                'label' => $this->l('Conversion Label:'),

                'name' => 'conversion_label',

                'size' => 70,

                'required' => true,

                'desc' => '<a href="'.$this->getDocumentationUrl().'" target="_blank">'.

                    $this->l('Read the documentation where to find this.').'</a>',

            ),

            array(

                'type' => 'select',

                'label' => $this->l('Price Calculation:'),

                'name' => 'price_calculation',

                'options' => array(

                    'query' => $this->price_calculation,

                    'id' => 'id',

                    'name' => 'name',

                ),

                'desc' => '',

            ),

            array(

                'type' => ($this->isPs15())?'radio':'switch',

                'label' => $this->l('Do you use Dynamic Product Ads:'),

                'name' => 'dpa',

                'class' => 't',

                'is_bool' => true,

                'values' => array(

                    array(

                        'id' => 'dpa_on',

                        'value' => 1,

                        'label' => $this->l('Yes')

                    ),

                    array(

                        'id' => 'dpa_off',

                        'value' => 0,

                        'label' => $this->l('No')

                    ),

                ),

                'desc' => $this->l('Only enable this option when you want to use Dynamic Product Ads

                and the pixel is associated to a product list.'),

            ),

            array(

                'type' => ($this->isPs15())?'radio':'switch',

                'label' => $this->l('Active:'),

                'name' => 'active',

                'class' => 't',

                'is_bool' => true,

                'values' => array(

                    array(

                        'id' => 'active_on',

                        'value' => 1,

                        'label' => $this->l('Yes')

                    ),

                    array(

                        'id' => 'active_off',

                        'value' => 0,

                        'label' => $this->l('No')

                    ),

                ),

                'desc' => $this->l('Enable or disable this conversion tracking code.'),

            ),

        );



        $this->fields_form[0]['form']['submit'] = array(

            'title' => $this->l('Save'),

        );



        $helper = new HelperForm();

        $helper->module = $this;

        $helper->name_controller = 'fsadconversion';

        $helper->identifier = $this->identifier;

        $helper->token = Tools::getAdminTokenLite('AdminModules');

        foreach (Language::getLanguages(false) as $lang) {

            $helper->languages[] = array(

                'id_lang' => $lang['id_lang'],

                'iso_code' => $lang['iso_code'],

                'name' => $lang['name'],

                'is_default' => ($default_lang == $lang['id_lang'] ? 1 : 0)

            );

        }

        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

        $helper->default_form_language = $default_lang;

        $helper->allow_employee_form_lang = $default_lang;

        $helper->toolbar_scroll = true;

        $helper->title[] = $this->displayName;

        $helper->submit_action = 'savefsadconversion';

        $helper->show_cancel_button = true;

        $helper->toolbar_btn = array(

            'save' =>

            array(

                'desc' => $this->l('Save'),

                'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.

                    $this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),

            ),

            'back' =>

            array(

                'href' => AdminController::$currentIndex.'&configure='.

                    $this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),

                'desc' => $this->l('Back to list')

            )

        );

        return $helper;

    }



    protected function initList()

    {

        $this->fields_list = array(

            'id_fsadconversion' => array(

                'title' => $this->l('ID'),

                'width' => 80,

            ),

            'type' => array(

                'title' => $this->l('Type'),

                'width' => 320,

                'type' => 'select',

                'list' => $this->ad_types_name,

                'filter_key' => 'type',

            ),

            'conversion_id' => array(

                'title' => $this->l('Conversion ID'),

            ),

            'active' => array(

                'title' => $this->l('Status'),

                'width' => 100,

                'type' => 'bool',

                'active' => 'status',

                'align' => 'center',

            ),

        );



        $helper = new HelperList();

        $helper->shopLinkType = '';

        $helper->simple_header = false;



        if ($this->isPs15()) {

            $helper->simple_header = true;

        }



        $helper->identifier = 'id_fsadconversion';

        $helper->actions = array('edit', 'delete');

        $helper->show_toolbar = true;

        $helper->imageType = 'jpg';

        $helper->toolbar_btn['new'] = array(

            'href' => AdminController::$currentIndex.'&configure='.$this->name.'&add'.

                $this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),

            'desc' => $this->l('Add new')

        );

        $helper->toolbar_btn['help'] = array(

            'href' => $this->getDocumentationUrl(),

            'desc' => $this->l('Documentation'),

            'target' => '_blank'

        );

        $helper->title[] = $this->displayName;

        $helper->table = $this->name;

        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;



        return $helper;

    }



    #################### FRONT HOOKS ####################



    public function hookDisplayHeader($params)

    {

        if ($this->isPsMin17()) {

            return $this->hookDisplayHeader17($params);

        }



        $conversion_codes = FsAdConversionModel::getAllActive();

        $this->context->controller->addJS(($this->_path).'views/js/front.js');



        $page = 'index';

        if (isset($this->context->controller->php_self)) {

            $page = $this->context->controller->php_self;

        }



        if (isset($this->context->controller->page_name)) {

            $page = $this->context->controller->page_name;

        }



        if ($this->context->controller instanceof ModuleFrontController) {

            if ($this->context->controller->module instanceof PaymentModule) {

                $page = 'payment';

            }

        }



        if ($page == 'payment') {

            if (Tools::isSubmit('key') && Tools::isSubmit('id_module')

                && Tools::isSubmit('id_cart') && Tools::isSubmit('id_order')) {

                $page = 'order-confirmation';

                $this->context->controller->id_order = (int)Tools::getValue('id_order');

            }

        }



        $standard_event = '';

        $event_parameters = array();

        switch ($page) {

            case 'product':

                $standard_event = 'ViewContent';

                if ($this->isPs15()) {

                    $product = new Product(Tools::getValue('id_product'), $this->context->language->id);

                } else {

                    $product = $this->context->controller->getProduct();

                }



                if (Validate::isLoadedObject($product)) {

                    $category = new Category($product->id_category_default);

                    $event_parameters['content_ids'] = array($product->id);

                    $event_parameters['content_type'] = 'product';

                    $event_parameters['content_name'] = $product->name;

                    $event_parameters['content_category'] = $category->getName();

                }

                break;

            case 'category':

                $standard_event = 'ViewContent';

                if ($this->isPs15()) {

                    $category = new Category(Tools::getValue('id_category'), $this->context->language->id);

                } else {

                    $category = $this->context->controller->getCategory();

                }



                if (Validate::isLoadedObject($category)) {

                    $products = $category->getProducts(

                        $this->context->language->id,

                        (int)Tools::getValue('p', 1),

                        (int)max(1, (int)Configuration::get('PS_PRODUCTS_PER_PAGE'))

                    );

                    $event_parameters['content_ids'] = array();

                    if ($products) {

                        foreach ($products as $p) {

                            $event_parameters['content_ids'][] = $p['id_product'];

                        }

                    }

                    $event_parameters['content_type'] = 'product_group';

                    $event_parameters['content_name'] = $category->name;

                }

                break;

            case 'search':

                $standard_event = 'Search';

                break;

            case 'order-opc':

                $standard_event = 'InitiateCheckout';

                break;

            case 'order':

                if (!$this->context->controller->step) {

                    $standard_event = 'InitiateCheckout';

                }

                break;

            case 'payment':

                $standard_event = 'AddPaymentInfo';

                break;

            case 'order-confirmation':

                $standard_event = 'Purchase';

                $order = new Order($this->context->controller->id_order);

                if (Validate::isLoadedObject($order)) {

                    $event_parameters['order_id'] = $order->id;

                    $event_parameters['content_type'] = 'product';



                    $products = $order->getProducts();

                    $event_parameters['content_ids'] = array();

                    $event_parameters['num_items'] = 0;

                    if ($products) {

                        foreach ($products as $p) {

                            $event_parameters['content_ids'][] = $p['product_id'];

                            $event_parameters['num_items'] += $p['product_quantity'];

                        }

                    }



                    if ($conversion_codes) {

                        $currency = new Currency((int)$order->id_currency);

                        foreach ($conversion_codes as &$conversion_code) {

                            $conversion_code['conversion_value'] = $this->getPrice(

                                $order,

                                $conversion_code['price_calculation']

                            );

                            $conversion_code['conversion_currency'] = $currency->iso_code;

                            $event_parameters['value'] = $conversion_code['conversion_value'];

                            $event_parameters['currency'] = $conversion_code['conversion_currency'];

                        }

                    }

                }

                break;

        }



        $this->context->smarty->assign(array(

            'fsac_conversion_codes' => $conversion_codes,

            'fsac_standard_event' => $standard_event,

            'fsac_event_parameters' => $event_parameters

        ));



        return $this->display($this->getModuleFile(), 'views/templates/hook/header.tpl');

    }



    public function hookDisplayHeader17($params)

    {

        $conversion_codes = FsAdConversionModel::getAllActive();

        $this->context->controller->addJS(($this->_path).'views/js/front-17.js');



        $page = 'index';

        if (isset($this->context->controller->php_self)) {

            $page = $this->context->controller->php_self;

        }



        if (!empty($_POST)) {

            // Change address hack

            if ($page == 'order') {

                if (Tools::isSubmit('confirm-addresses') || Tools::isSubmit('submitAddress')) {

                    FsAdConversionDataTransfer::setData(array('fsac_page' => 'shipping'));

                }

            }



            // Check for auth events login and create account.

            if (($page == 'authentication') || ($page == 'order')) {

                if (Tools::isSubmit('submitLogin')) {

                    FsAdConversionDataTransfer::setData(array('fsac_page' => 'login'));

                }



                if (Tools::isSubmit('submitCreate')) {

                    FsAdConversionDataTransfer::setData(array('fsac_page' => 'register'));

                }

            }

        } else {

            // Handle account creation event

            $data = FsAdConversionDataTransfer::getData();

            if (isset($data['fsac_page'])) {

                $page = $data['fsac_page'];

            }



            if ($page == 'order') {

                $checkout_session_data = Db::getInstance()->getValue(

                    'SELECT checkout_session_data FROM '._DB_PREFIX_.

                    'cart WHERE id_cart = '.(int) $this->context->cart->id

                );



                if ($checkout_session_data) {

                    $checkout_session_data = $this->jsonDecode($checkout_session_data, true);

                    $saved_checksum = '';

                    if (isset($checkout_session_data['checksum'])) {

                        $saved_checksum = $checkout_session_data['checksum'];

                    }



                    $cart_checksum_generator = new CartChecksum(new AddressChecksum());

                    $cart_checksum = $cart_checksum_generator->generateChecksum($this->context->cart);



                    // Other way always InitiateCheckout

                    // because the cart changed and $checkout_session_data is not correct

                    if ($saved_checksum == $cart_checksum) {

                        $current_step = '';

                        foreach ($checkout_session_data as $step => $states) {

                            if (isset($states['step_is_reachable']) && $states['step_is_reachable']) {

                                $current_step = $step;

                            }

                        }



                        if ($current_step == 'checkout-delivery-step') {

                            $page = 'shipping';

                        }



                        if ($current_step == 'checkout-payment-step') {

                            $page = 'payment';

                        }

                    }

                }

            }



            // If the module has an extra confirmation page during a checkout process.

            if ($this->context->controller instanceof ModuleFrontController) {

                if ($this->context->controller->module instanceof PaymentModule) {

                    $page = 'payment';

                }

            }



            // If the module handle the order confirmation page.

            if ($page == 'payment') {

                if (Tools::isSubmit('key') && Tools::isSubmit('id_module')

                    && Tools::isSubmit('id_cart') && Tools::isSubmit('id_order')) {

                    $page = 'order-confirmation';

                    $this->context->controller->id_order = (int)Tools::getValue('id_order');

                }

            }



            $standard_event = '';

            $event_parameters = array();

            switch ($page) {

                case 'register':

                    $standard_event = 'CompleteRegistration';

                    break;

                case 'search':

                    $standard_event = 'Search';

                    break;

                case 'order':

                    $standard_event = 'InitiateCheckout';

                    break;

                case 'payment':

                    $standard_event = 'AddPaymentInfo';

                    break;

                case 'shipping':

                    $standard_event = 'AddShippingInfo';

                    break;

                case 'product':

                    $standard_event = 'ViewContent';

                    if ($this->isPs15()) {

                        $product = new Product(Tools::getValue('id_product'), $this->context->language->id);

                    } else {

                        $product = $this->context->controller->getProduct();

                    }



                    if (Validate::isLoadedObject($product)) {

                        $category = new Category($product->id_category_default);

                        $event_parameters['content_ids'] = array($product->id);

                        $event_parameters['content_type'] = 'product';

                        $event_parameters['content_name'] = $product->name;

                        $event_parameters['content_category'] = $category->getName();

                    }

                    break;

                case 'category':

                    $standard_event = 'ViewContent';

                    if ($this->isPs15()) {

                        $category = new Category(Tools::getValue('id_category'), $this->context->language->id);

                    } else {

                        $category = $this->context->controller->getCategory();

                    }



                    if (Validate::isLoadedObject($category)) {

                        $products = $category->getProducts(

                            $this->context->language->id,

                            (int)Tools::getValue('p', 1),

                            (int)max(1, (int)Configuration::get('PS_PRODUCTS_PER_PAGE'))

                        );

                        $event_parameters['content_ids'] = array();

                        if ($products) {

                            foreach ($products as $p) {

                                $event_parameters['content_ids'][] = $p['id_product'];

                            }

                        }

                        $event_parameters['content_type'] = 'product_group';

                        $event_parameters['content_name'] = $category->name;

                    }

                    break;

                case 'order-confirmation':

                    $standard_event = 'Purchase';

                    $order = new Order($this->context->controller->id_order);

                    if (Validate::isLoadedObject($order)) {

                        $event_parameters['order_id'] = $order->id;

                        $event_parameters['content_type'] = 'product';



                        $products = $order->getProducts();

                        $event_parameters['content_ids'] = array();

                        $event_parameters['num_items'] = 0;

                        if ($products) {

                            foreach ($products as $p) {

                                $event_parameters['content_ids'][] = $p['product_id'];

                                $event_parameters['num_items'] += $p['product_quantity'];

                            }

                        }



                        if ($conversion_codes) {

                            $currency = new Currency((int)$order->id_currency);

                            foreach ($conversion_codes as &$conversion_code) {

                                $conversion_code['conversion_value'] = $this->getPrice(

                                    $order,

                                    $conversion_code['price_calculation']

                                );

                                $conversion_code['conversion_currency'] = $currency->iso_code;

                                $event_parameters['value'] = $conversion_code['conversion_value'];

                                $event_parameters['currency'] = $conversion_code['conversion_currency'];

                            }

                        }

                    }

                    break;

            }



            $this->context->smarty->assign(array(

                'fsac_conversion_codes' => $conversion_codes,

                'fsac_standard_event' => $standard_event,

                'fsac_event_parameters' => $event_parameters,

                'fsac_params_hash' => sha1($this->jsonEncode($params))

            ));



            return $this->fetch('module:'.$this->name.'/views/templates/hook/header_17.tpl');

        }



        return '';

    }



    public function hookDisplayOrderConfirmation($params)

    {

        if ($this->isPsMin17()) {

            $order = $params['order'];

        } else {

            $order = $params['objOrder'];

        }

        if (Validate::isLoadedObject($order)) {

            $conversion_codes = FsAdConversionModel::getAllActive();

            if ($conversion_codes) {

                $currency = new Currency((int)$order->id_currency);

                foreach ($conversion_codes as $key => $conversion_code) {

                    $conversion_codes[$key]['conversion_value'] =

                        $this->getPrice($order, $conversion_code['price_calculation']);

                    $conversion_codes[$key]['conversion_currency'] =

                        $currency->iso_code;

                }



                $this->context->smarty->assign(array(

                    'fsac_conversion_codes' => $conversion_codes

                ));



                if ($this->isPsMin17()) {

                    return $this->fetch(

                        'module:'.$this->name.'/views/templates/hook/display_order_confirmation_17.tpl'

                    );

                }



                return $this->display(

                    $this->getModuleFile(),

                    'views/templates/hook/display_order_confirmation.tpl'

                );

            }

        }

        return '';

    }



    private function getCssAndJs()

    {

        $context = Context::getContext();

        $context->smarty->assign(array(

            'is_ps_15' => $this->isPs15(),

            'is_ps_min_16' => $this->isPsMin16(),

            'module_base_url' => $this->getModuleBaseUrl()

        ));



        return $this->display(__FILE__, 'views/templates/admin/css_js.tpl');

    }



    private function getPrice($obj_order, $price_calculation)

    {

        $o = $obj_order;

        $price = $o->total_products_wt;

        switch ($price_calculation) {

            case 1:

                $price = $o->total_products;

                break;

            case 2:

                $price = $o->total_products_wt;

                break;

            case 3:

                $price = $o->total_products + $o->total_shipping_tax_excl;

                break;

            case 4:

                $price = $o->total_products_wt + $o->total_shipping_tax_incl;

                break;

            case 5:

                $price = $o->total_products + $o->total_wrapping_tax_excl;

                break;

            case 6:

                $price = $o->total_products_wt + $o->total_wrapping_tax_incl;

                break;

            case 7:

                $price = $o->total_products + $o->total_shipping_tax_excl + $o->total_wrapping_tax_excl;

                break;

            case 8:

                $price = $o->total_products_wt + $o->total_shipping_tax_incl + $o->total_wrapping_tax_incl;

                break;

        }

        return $price;

    }



    public function removeDpa($params)

    {

        unset($params['content_ids']);

        unset($params['content_type']);

        return $params;

    }



    ################ 1.7 ################



    /**

     * @return bool

     */

    public function isPs15()

    {

        return self::isPs15Static();

    }



    /**

     * @return bool

     */

    public static function isPs15Static()

    {

        return version_compare(_PS_VERSION_, '1.5.0.0', '>=') &&

        version_compare(_PS_VERSION_, '1.6.0.0', '<');

    }



    /**

     * @return bool

     */

    public function isPsMin16()

    {

        return self::isPsMin16Static();

    }



    /**

     * @return bool

     */

    public static function isPsMin16Static()

    {

        return version_compare(_PS_VERSION_, '1.6.0.0', '>=');

    }



    /**

     * @return bool

     */

    public function isPs16()

    {

        return self::isPs16Static();

    }



    /**

     * @return bool

     */

    public static function isPs16Static()

    {

        return version_compare(_PS_VERSION_, '1.6.0.0', '>=') &&

        version_compare(_PS_VERSION_, '1.7.0.0', '<');

    }



    /**

     * @return bool

     */

    public function isPsMin17()

    {

        return self::isPsMin17Static();

    }



    /**

     * @return bool

     */

    public static function isPsMin17Static()

    {

        return version_compare(_PS_VERSION_, '1.7.0.0', '>=');

    }



    /**

     * @param $data

     * @return string

     */

    public function jsonEncode($data)

    {

        return self::jsonEncodeStatic($data);

    }



    /**

     * @param $data

     * @return string

     */

    public static function jsonEncodeStatic($data)

    {

        if (self::isPsMin17Static()) {

            return json_encode($data);

        }

        return Tools::jsonEncode($data);

    }



    /**

     * @param $data

     * @param bool $assoc

     * @return array|mixed

     */

    public function jsonDecode($data, $assoc = false)

    {

        return self::jsonDecodeStatic($data, $assoc);

    }



    /**

     * @param $data

     * @param bool $assoc

     * @return array|mixed

     */

    public static function jsonDecodeStatic($data, $assoc = false)

    {

        if (self::isPsMin17Static()) {

            return json_decode($data, $assoc);

        }

        return Tools::jsonDecode($data, $assoc);

    }

}

