<?php
/**
 * Catalog in CSV format module
 *
 * @category  Prestashop
 * @category  Module
 * @author    Samdha <contact@samdha.net>
 * @copyright Samdha
 * @license   commercial license see license.txt
 * @link      http://www.gnu.org/copyleft/gpl.html logo license
 * @link      http://linux.softpedia.com/developer/Oliver-Scholtz-93.html Oliver Scholtz (and others) logo author
 * @version   2.0.21.0
 */

if (!defined('_PS_VERSION_'))
	exit;

if (!class_exists('export_catalog', false))
{
	if (!defined('_PS_MODULE_DIR_')) /* PS 1.0 */
		define('_PS_MODULE_DIR_', _PS_ROOT_DIR_.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR);
	if (!defined('_PS_USE_SQL_SLAVE_')) /* PS 1.3 */
		define('_PS_USE_SQL_SLAVE_', false);

	/**
	 * Autoloader for this module classes
	 */
	function exportCatalogAutoload($class_name)
	{
		$module_name = 'export_catalog';
		$class_name = ltrim($class_name, '\\');
		$file_name  = '';
		$namespace = '';
		if ($last_ns_post = strrpos($class_name, '\\'))
		{
			$namespace = Tools::substr($class_name, 0, $last_ns_post);
			$class_name = Tools::substr($class_name, $last_ns_post + 1);
			$file_name  = str_replace('\\', DIRECTORY_SEPARATOR, $namespace).DIRECTORY_SEPARATOR;
		}
		$file_name .= str_replace('_', DIRECTORY_SEPARATOR, $class_name).'.php';
		$file_name = _PS_MODULE_DIR_.$module_name.DIRECTORY_SEPARATOR.'classes'.DIRECTORY_SEPARATOR.$file_name;
		if (file_exists($file_name))
			return require_once($file_name);
		elseif (version_compare(_PS_VERSION_, '1.4.0.0', '>=') && function_exists('__autoload'))
			return __autoload($class_name);
		elseif (version_compare(_PS_VERSION_, '1.4.0.0', '<') && is_readable(_PS_ROOT_DIR_.'/classes/'.$class_name.'.php'))
			require_once _PS_ROOT_DIR_.'/classes/'.$class_name.'.php';
	}
	spl_autoload_register('exportCatalogAutoload');


	class Export_Catalog extends Samdha_Module_Module
	{
		public $config_global = true;
		public $short_name = 'exp_cat';
		public $mail_path = null;

		public function __construct()
		{
			$this->name = 'export_catalog';
			$this->tab = version_compare(_PS_VERSION_, '1.4.0.0', '<')?'Tools':'export';
			$this->version = '2.0.21.0';
			$this->bootstrap = true;
			$this->module_key = '2273c3ab9415bd47e68a79cc0efe273e';

			/* Validator compatibility *//*
			$this->author = 'Samdha';
			if (version_compare(_PS_VERSION_, '1.5.0.0', '<'))
				require(_PS_MODULE_DIR_.$this->name.'/backward_compatibility/backward.php');
			if (function_exist(function_exists('curl_init'))
				require(_PS_MODULE_DIR_.$this->name.'/backward_compatibility/backward.php');
			*/
			parent::__construct();

			$this->page = basename(__FILE__, '.php');
			$this->displayName = $this->l('Catalog in CSV format');
			$this->description = $this->l('Allows you to download your catalog in CSV format.');
			$this->mail_path = _PS_MODULE_DIR_.$this->name.DIRECTORY_SEPARATOR.'mails'.DIRECTORY_SEPARATOR;

			$this->tools = new Samdha_ExportCatalog_Tools($this);
		}

		public function postProcess($token)
		{
			$currentIndex = AdminController::$currentIndex;

			// need to convert the old config ?
			if (is_writable(_PS_ROOT_DIR_.$this->config->_directory)
				&& $this->config->_filename)
			{
				$this->tools->importOldConfig();
				$this->postUpdateModule();
				Tools::redirectAdmin($currentIndex.'&module_name='.$this->name.'&configure='.$this->name.'&token='.$token);
			}

			if (Tools::isSubmit('actionSaveModel'))
			{
				$conf = new Samdha_ExportCatalog_Model(
					_PS_ROOT_DIR_.$this->config->_directory,
					$this,
					Tools::getValue($this->short_name.'_model')
				);

				// if no categorie is checked
				$model = Tools::getValue('model');
				if (!is_array($model)) // should never happend
				{
					$_POST['model'] = array();
					$_POST['model']['datas'] = array();
					$_POST['model']['datas']['categories'] = array();
					$_POST['model']['datas']['manufacturers'] = array();
					$_POST['model']['datas']['suppliers'] = array();
				}
				elseif (!isset($model['datas']) || !is_array($model['datas'])) // should never happend
				{
					$_POST['model']['datas'] = array();
					$_POST['model']['datas']['categories'] = array();
					$_POST['model']['datas']['manufacturers'] = array();
					$_POST['model']['datas']['suppliers'] = array();
				}

				if (!isset($model['datas']['categories']) || !is_array($model['datas']['categories'])) // may happend
					$_POST['model']['datas']['categories'] = array();
				if (!isset($model['datas']['manufacturers']) || !is_array($model['datas']['manufacturers'])) // may happend
					$_POST['model']['datas']['manufacturers'] = array();
				if (!isset($model['datas']['suppliers']) || !is_array($model['datas']['suppliers'])) // may happend
					$_POST['model']['datas']['suppliers'] = array();

				$conf->loadFromArray(Tools::getValue('model'));
				$conf->save();
				$this->config->_model = $conf->filename;
				$url = $currentIndex.'&module_name='.$this->name.'&configure='.$this->name;
				$url .= '&conf='.(Tools::getValue($this->short_name.'_model')?'4':'3').'&token='.$token;
				Tools::redirectAdmin($url);
			}

			if (Tools::isSubmit('actionDuplicateModel'))
			{
				$conf = new Samdha_ExportCatalog_Model(
					_PS_ROOT_DIR_.$this->config->_directory,
					$this,
					Tools::getValue($this->short_name.'_model')
				);
				$conf->filename = '';
				$conf->name .= ' '.$this->l('(copy)');
				$conf->save();
				$this->config->_model = $conf->filename;
				$url = $currentIndex.'&module_name='.$this->name.'&configure='.$this->name;
				$url .= '&conf=19&token='.$token;
				Tools::redirectAdmin($url);
			}

			if (Tools::isSubmit('actionDeleteModel'))
			{
				$conf = new Samdha_ExportCatalog_Model(
					_PS_ROOT_DIR_.$this->config->_directory,
					$this,
					Tools::getValue($this->short_name.'_model')
				);
				$conf->delete();
				$files = $conf->getFiles();
				if (!empty($files))
				{
					$keys = array_keys($files);
					$this->config->_model = reset($keys);
				}
				else
					$this->config->_model = '';
				Tools::redirectAdmin($currentIndex.'&module_name='.$this->name.'&configure='.$this->name.'&conf=1&token='.$token);
			}

			if (Tools::isSubmit('actionLoadModel'))
			{
				$conf = new Samdha_ExportCatalog_Model(
					_PS_ROOT_DIR_.$this->config->_directory,
					$this,
					Tools::getValue($this->short_name.'_model')
				);
				$this->config->_model = $conf->filename;
				Tools::redirectAdmin($currentIndex.'&module_name='.$this->name.'&configure='.$this->name.'&token='.$token);
			}

			if (Tools::isSubmit('actionDownloadModel'))
			{
				if (ob_get_level())
					ob_end_clean();
				ob_start();
				if (version_compare(_PS_VERSION_, '1.5.3.0', '>='))
					register_shutdown_function(array($this->tools, 'fixDisplayFatalError'));
				$conf = new Samdha_ExportCatalog_Model(
					_PS_ROOT_DIR_.$this->config->_directory,
					$this,
					Tools::getValue($this->short_name.'_model')
				);
				$conf->sendToBrowser();
				Tools::redirectAdmin($currentIndex.'&module_name='.$this->name.'&configure='.$this->name.'&token='.$token);
			}

			if (Tools::isSubmit('actionUploadModel'))
			{
				if ($_FILES['model_filename']['tmp_name'])
				{
					$conf = new Samdha_ExportCatalog_Model(
						_PS_ROOT_DIR_.$this->config->_directory,
						$this
					);
					if ($conf->copyFromFile($_FILES['model_filename']['tmp_name']))
					{
						$this->config->_model = $conf->filename;
						Tools::redirectAdmin($currentIndex.'&module_name='.$this->name.'&configure='.$this->name.'&conf=18&token='.$token);
					}
					else
						$this->errors[] = $this->l('Upload error.');
				}
				else
					$this->errors[] = $this->l('Upload error.');
			}

			if (Tools::isSubmit('actionSaveExport'))
			{
				$conf = new Samdha_ExportCatalog_Export(
					_PS_ROOT_DIR_.$this->config->_directory,
					$this,
					Tools::getValue($this->short_name.'_export')
				);
				$conf->loadFromArray(Tools::getValue('export'));
				$conf->save();
				$this->config->_export = $conf->filename;
				Tools::redirectAdmin($currentIndex.'&module_name='.$this->name.'&configure='.$this->name.'&conf='.(Tools::getValue($this->short_name.'_export')?'4':'3').'&token='.$token.'&active_tab=tabCron');
			}

			if (Tools::isSubmit('actionDuplicateExport'))
			{
				$conf = new Samdha_ExportCatalog_Export(
					_PS_ROOT_DIR_.$this->config->_directory,
					$this,
					Tools::getValue($this->short_name.'_export')
				);
				$conf->filename = '';
				$conf->name .= ' '.$this->l('(copy)');
				$conf->save();
				$this->config->_export = $conf->filename;
				Tools::redirectAdmin($currentIndex.'&module_name='.$this->name.'&configure='.$this->name.'&conf=19&token='.$token.'&active_tab=tabCron');
			}

			if (Tools::isSubmit('actionDeleteExport'))
			{
				$conf = new Samdha_ExportCatalog_Export(
					_PS_ROOT_DIR_.$this->config->_directory,
					$this,
					Tools::getValue($this->short_name.'_export')
				);
				$conf->delete();
				$files = $conf->getFiles();
				if (!empty($files))
				{
					$keys = array_keys($files);
					$this->config->_export = reset($keys);
				}
				else
					$this->config->_export = '';
				Tools::redirectAdmin($currentIndex.'&module_name='.$this->name.'&configure='.$this->name.'&conf=1&token='.$token.'&active_tab=tabCron');
			}

			if (Tools::isSubmit('actionLoadExport'))
			{
				$conf = new Samdha_ExportCatalog_Export(
					_PS_ROOT_DIR_.$this->config->_directory,
					$this,
					Tools::getValue($this->short_name.'_export')
				);
				$this->config->_export = $conf->filename;
				Tools::redirectAdmin($currentIndex.'&module_name='.$this->name.'&configure='.$this->name.'&token='.$token.'&active_tab=tabCron');
			}

			if (Tools::isSubmit('actionExportModel'))
			{
				if (ob_get_level())
					ob_end_clean();
				ob_start();
				if (version_compare(_PS_VERSION_, '1.5.3.0', '>='))
					register_shutdown_function(array($this->tools, 'fixDisplayFatalError'));
				$model = new Samdha_ExportCatalog_Model(
					_PS_ROOT_DIR_.$this->config->_directory,
					$this,
					Tools::getValue('model')
				);
				$model->restoreContext();
				$model->export(base64_decode(Tools::getValue('filename')));
				die();
			}

			if (Tools::getValue('ajax')
				&& ($action = Tools::getValue('action'))
				&& method_exists($this, $action))
			{
				if (ob_get_level())
					ob_end_clean();
				ob_start();
				if (version_compare(_PS_VERSION_, '1.5.3.0', '>='))
					register_shutdown_function(array($this->tools, 'fixDisplayFatalError'));
				call_user_func(array($this, $action));
				die();
			}

			$result = parent::postProcess($token);

			if (!is_writable(_PS_ROOT_DIR_.$this->config->_directory))
				$this->errors[] = $this->l('The working directory is not writable. Make it writable or choose another directory in the "Parameters" tab.');

			if ($this->config->_export)
			{
				$iso_lang = Language::getIsoById((int)Configuration::get('PS_LANG_DEFAULT'));
				if (!file_exists($this->mail_path.$iso_lang.DIRECTORY_SEPARATOR.$this->name.'.html'))
					$this->errors[] = $this->l('The mail templates are not avaible in the shop default language. You can create them using the translation tool of Prestashop.');

				// reinstall cron if deleted
				$cron_module = Module::getInstanceByName('cron');
				$cron_exists = Validate::isLoadedObject($cron_module) && $cron_module->active;

				if ($this->config->_cron
					&& $cron_exists
					&& !$cron_module->cronExists($this->id, 'cron'))
				{
					$cron_module->addCron(
						$this->id,
						'cron',
						'0,10,20,30,40,50 * * * *'
					);
				}

				if ($this->config->_cron
					&& $cron_exists
					&& !$cron_module->cronExists($this->id, 'cron'))
				{
					$this->errors = array_merge($this->errors, $cron_module->_postErrors);
					$this->errors[] = $this->l('Unabled to create cron task');
				}

				if (!$this->config->_cron
					&& $cron_exists
					&& $cron_module->cronExists($this->id, 'cron'))
					$cron_module->deleteCron($this->id, 'cron');

				if (!isset($this->config->_token) || !$this->config->_token)
					$this->config->_token = Tools::passwdGen();
			}
			else
			{
				$cron_module = Module::getInstanceByName('cron');
				$cron_exists = Validate::isLoadedObject($cron_module) && $cron_module->active;
				if ($cron_exists && $cron_module->cronExists($this->id, 'cron'))
					$cron_module->deleteCron($this->id, 'cron');
			}
			if ((!isset($this->config->host) || !$this->config->host) && isset($_SERVER['HTTP_HOST']))
				$this->config->host = $this->samdha_tools->getHttpHost(true);

			return $result;
		}

		public function displayForm($token, $big = true, $space = false)
		{
			$cookie = $this->context->cookie;
			$smarty = $this->smarty;
			$currentIndex = AdminController::$currentIndex;

			$model = new Samdha_ExportCatalog_Model(
				_PS_ROOT_DIR_.$this->config->_directory,
				$this,
				$this->config->_model
			);
			if (!$model->filename)
			{
				$files = $model->getFiles();
				if (!empty($files))
				{
					$keys = array_keys($files);
					$model->loadFromFile(reset($keys));
					$this->config->_model = $model->filename;
				}
				else
					$this->config->_model = '';
			}

			$tmp_model = new Samdha_ExportCatalog_Model(
				_PS_ROOT_DIR_.$this->config->_directory,
				$this
			);
			$files = $tmp_model->getFiles();
			$keys = array_keys($files);
			$models_shop = array();
			foreach ($keys as $key)
			{
				$tmp_model->loadFromFile($key);
				$models_shop[$tmp_model->filename] = $tmp_model->datas['id_shop'];
			}
			unset($tmp_model);

			$export = new Samdha_ExportCatalog_Export(
				_PS_ROOT_DIR_.$this->config->_directory,
				$this,
				$this->config->_export
			);
			if (!$export->filename)
			{
				$files = $export->getFiles();
				if (!empty($files))
				{
					$keys = array_keys($files);
					$export->loadFromFile(reset($keys));
					$this->config->_export = $export->filename;
				}
				else
					$this->config->_export = '';
			}

			$tmp_export = new Samdha_ExportCatalog_Export(
				_PS_ROOT_DIR_.$this->config->_directory,
				$this
			);
			$files = $tmp_export->getFiles();
			$keys = array_keys($files);
			$exports_shop = array();
			foreach ($keys as $key)
			{
				$tmp_export->loadFromFile($key);
				$exports_shop[$tmp_export->filename] = $models_shop[$tmp_export->datas['model']];
			}
			unset($tmp_export);

			$id_lang = $cookie->id_lang;
			$tmp = Language::getLanguages();
			$languages = array();
			foreach ($tmp as $lang)
				$languages[$lang['id_lang']] = $lang['name'];

			$tmp = Currency::getCurrencies();
			$currencies = array();
			foreach ($tmp as $currency)
				$currencies[$currency['id_currency']] = $currency['name'];

			$tmp = Country::getCountries($cookie->id_lang, true);
			$countries = array();
			foreach ($tmp as $country)
				$countries[$country['id_country']] = $country['name'];

			$tmp = Group::getGroups($cookie->id_lang);
			$groups = array();
			foreach ($tmp as $group)
				$groups[$group['id_group']] = $group['name'];

			$tmp = Manufacturer::getManufacturers(false, $cookie->id_lang);
			$manufacturers = array();
			foreach ($tmp as $manufacturer)
				$manufacturers[$manufacturer['id_manufacturer']] = $manufacturer['name'];

			$tmp = Supplier::getSuppliers(false, $cookie->id_lang);
			$suppliers = array();
			foreach ($tmp as $supplier)
				$suppliers[$supplier['id_supplier']] = $supplier['name'];

			if (class_exists('Shop', false))
			{
				$tmp = Shop::getShops();
				$shops = array();
				foreach ($tmp as $shop)
					$shops[$shop['id_shop']] = $shop['name'];
			}
			else
				$shops = false;

			$categories = $this->tools->getCategories($cookie->id_lang, false);

			$tmp = ImageType::getImagesTypes('products');
			$images_types = array();
			foreach ($tmp as $image_type)
				$images_types[$image_type['name']] = $image_type['name'];

			if (function_exists('mb_list_encodings'))
				$tmp = mb_list_encodings();
			else
			{
				$tmp = array(
					'pass',
					'auto',
					'wchar',
					'byte2be',
					'byte2le',
					'byte4be',
					'byte4le',
					'BASE64',
					'UUENCODE',
					'HTML-ENTITIES',
					'Quoted-Printable',
					'7bit',
					'8bit',
					'UCS-4',
					'UCS-4BE',
					'UCS-4LE',
					'UCS-2',
					'UCS-2BE',
					'UCS-2LE',
					'UTF-32',
					'UTF-32BE',
					'UTF-32LE',
					'UTF-16',
					'UTF-16BE',
					'UTF-16LE',
					'UTF-8',
					'UTF-7',
					'UTF7-IMAP',
					'ASCII',
					'EUC-JP',
					'SJIS',
					'eucJP-win',
					'SJIS-win',
					'JIS',
					'ISO-2022-JP',
					'Windows-1252',
					'ISO-8859-1',
					'ISO-8859-2',
					'ISO-8859-3',
					'ISO-8859-4',
					'ISO-8859-5',
					'ISO-8859-6',
					'ISO-8859-7',
					'ISO-8859-8',
					'ISO-8859-9',
					'ISO-8859-10',
					'ISO-8859-13',
					'ISO-8859-14',
					'ISO-8859-15',
					'EUC-CN',
					'CP936',
					'HZ',
					'EUC-TW',
					'BIG-5',
					'EUC-KR',
					'UHC',
					'ISO-2022-KR',
					'Windows-1251',
					'CP866',
					'KOI8-R',
				);
			}
			$charsets = array();
			foreach ($tmp as $charset)
				$charsets[$charset] = $charset;

			$tmp = Employee::getEmployees();
			$employees = array();
			foreach ($tmp as $employee)
				if (array_key_exists('firstname', $employee))
					$employees[$employee['id_employee']] = $employee['firstname'].' '.$employee['lastname'];
				else
					$employees[$employee['id_employee']] = $employee['name'];

			$days = array(
				0 => $this->l('Sunday'),
				1 => $this->l('Monday'),
				2 => $this->l('Tuesday'),
				3 => $this->l('Wednesday'),
				4 => $this->l('Thursday'),
				5 => $this->l('Friday'),
				6 => $this->l('Saturday')
			);

			$cron_module = Module::getInstanceByName('cron');
			$cron_exists = Validate::isLoadedObject($cron_module) && $cron_module->active;
			$task_created = $cron_exists && $cron_module->cronExists($this->id, 'cron');

			$smarty->assign(
				array(
					'about_form'        => parent::displayForm($token, false),
					'module_config'     => $this->config->getAsArray(),
					'module_short_name' => $this->short_name,
					'module_url'        => $currentIndex.'&configure='.urlencode($this->name).'&token='.$token,
					'module_path'       => '//'.$this->samdha_tools->getHttpHost(false).$this->_path,
					'module_directory'  => dirname(__FILE__),
					'php_dir'           => $this->tools->getPHPExecutableFromPath(),
					'active_tab'        => Tools::getValue('active_tab'),
					'support_url'       => $this->licence->licence_number?$this->licence->getSupportURL():$this->licence->getLicenceURL(),
					'documentation_url' => $this->getDocumentationURL(),
					'version_14'        => version_compare(_PS_VERSION_, '1.4.0.0', '>='),
					'version_15'        => version_compare(_PS_VERSION_, '1.5.0.0', '>='),
					'version_16'        => version_compare(_PS_VERSION_, '1.6.0.0', '>='),
					'bootstrap'         => $this->bootstrap,
					'module_version'    => $this->version,

					'model'           => $model,
					'possible_fields' => $model->getPossibleFields($id_lang),
					'charsets'        => $charsets,
					'images_types'    => $images_types,
					'categories'      => $this->tools->recurseCategoryForInclude($model->datas['categories'], $categories, $categories[0][1], 1),
					'languages'       => $languages,
					'currencies'      => $currencies,
					'countries'       => $countries,
					'groups'          => $groups,
					'manufacturers'   => $manufacturers,
					'suppliers'       => $suppliers,
					'shops'           => $shops,
					'models_shop'     => $models_shop,
					'exports_shop'    => $exports_shop,

					'export'          => $export,
					'employees'       => $employees,
					'days'            => $days,
					'hours'           => range(0, 23),
					'minutes'         => range(0, 59),

					'cron_exists'     => $cron_exists,
					'task_created'    => $task_created,

					'writable'        => is_writable(_PS_ROOT_DIR_.$this->config->_directory),
				)
			);
			// Display Form

			$output = $this->display(__FILE__, (version_compare(_PS_VERSION_, '1.5.0.0', '<')?'/views/templates/hook/':'').$this->name.'.tpl');
			return $output;
		}

		/* set default config */
		public function getDefaultConfig()
		{
			return array(
				'_cron' => '1', // use cron module
				'_token' => null, // password for cron job

				'_id_customer' => 0, // For shipping cost computation @since 1.2.4.0
				'_id_address' => 0, // For shipping cost computation @since 1.2.4.0
				'_id_cart' => 0, // For shipping cost computation @since 1.2.4.0

				'_model' => '', // @since 1.2.4.0
				'_export' => '', // @since 1.2.4.0
				'_directory' => str_replace(
					DIRECTORY_SEPARATOR,
					'/',
					Tools::substr(dirname(__FILE__), Tools::strlen(_PS_ROOT_DIR_))
				).'/datas/', // @since 1.2.4.0
				'_next_shop' => Configuration::get('PS_SHOP_DEFAULT'),
				'host' => ''
			);
		}

		private function preExportCatalog($echo = true, $current = 0, $limit = 250, $first_attribute = 0, $export = null)
		{
			@set_time_limit(600);
			$cart = $this->context->cart;
			if (!isset($cart))
				$cart = new Cart();

			if (!$export)
			{
				if (Tools::getValue('export'))
				{
					$export = new Samdha_ExportCatalog_Export(
						_PS_ROOT_DIR_.$this->config->_directory,
						$this,
						Tools::getValue('export')
					);
					$model = $export->getModel();
				}
				else
				{
					$model = new Samdha_ExportCatalog_Model(
						_PS_ROOT_DIR_.$this->config->_directory,
						$this,
						Tools::getValue('model')
					);
				}
			}
			else
				$model = $export->getModel();

			$host = version_compare(_PS_VERSION_, '1.4.0.0', '<')?$this->config->host:'';
			if (version_compare(_PS_VERSION_, '1.4.0.0', '<') && !isset($_SERVER['HTTP_HOST']))
			{
				$url = parse_url($this->config->host);
				$_SERVER['HTTP_HOST'] = $url['host'];
			}
			if (version_compare(_PS_VERSION_, '1.4.0.0', '<') && !defined('_PS_BASE_URL_'))
				define('_PS_BASE_URL_', $this->config->host);
			$model->setContext();

			if (Tools::getValue('current') !== false)
				$current = Tools::getValue('current');
			if (Tools::getValue('first_attribute') !== false)
				$first_attribute = Tools::getValue('first_attribute');
			if (Tools::getValue('total'))
				$total = (int)Tools::getValue('total');
			else
				$total = $model->countProducts();
			if (($total - (int)Tools::getValue('done')) < $limit)
				$limit = 0;

			$nb_product = 0; // will be updated by $model->getProducts
			$last_attribute = 0; // will be updated by $model->getProducts
			$products = $model->getProducts($current, $limit, $nb_product, $first_attribute, $last_attribute);

			if (Tools::getValue('filename'))
				$filename = base64_decode(Tools::getValue('filename'));
			else
				$filename = tempnam(_PS_ROOT_DIR_.$this->config->_directory, $this->name);

			$out = fopen($filename, 'a');

			if ($current == 0 && $first_attribute == 0)
				$model->writeHeader($out);

			$model->writeProducts($out, $products, $host);
			fclose($out);

			if ($echo)
			{
				if ($nb_product == 0 && $last_attribute == 0)
					$next = -1;
				else
				{
					$next = $current + $nb_product;
					if ($last_attribute != 0)
						$next--;
				}

				echo $this->samdha_tools->jsonEncode(
					array(
						'status' => 'success',
						'data'   => array(
							'next'           => $next,
							'last_attribute' => $last_attribute,
							'total'          => $total,
							'done'           => Tools::getValue('done') + count($products),
							'filename'       => base64_encode($filename)
						)
					)
				);
			}
			else
				return $filename;
		}

		private function postExportCatalog($echo = true, $export = null, $filename = null)
		{
			@set_time_limit(600);

			if (!$filename)
				$filename = base64_decode(Tools::getValue('filename'));

			if (!$export)
			{
				$export = new Samdha_ExportCatalog_Export(
					_PS_ROOT_DIR_.$this->config->_directory,
					$this,
					Tools::getValue('export')
				);
			}
			$export->export($filename, $this);

			if ($echo)
				echo $this->samdha_tools->jsonEncode(array('status' => 'success'));
		}

		/**
		 * called for testing ajax call
		 * @return void
		 */
		private function ajaxTest()
		{
			echo $this->samdha_tools->jsonEncode(array('status' => 'success'));
		}

		/**
		 * scheduled export
		 */
		public function cron($from_url = false)
		{
			if (!$from_url
				|| ($this->config->_token == Tools::getValue('token')))
			{
				$export = new Samdha_ExportCatalog_Export(
					_PS_ROOT_DIR_.$this->config->_directory,
					$this
				);
				$exports = $export->getFiles();
				if (!empty($exports))
				{
					$id_shops = array();
					foreach ($exports as $id_export => $name)
					{
						$export->loadFromFile($id_export);
						$id_shop = $export->getModel()->datas['id_shop'];
						$id_shops[$id_shop] = $id_shop;
						if (!isset($export->datas['next_run']))
						{
							$export->datas['next_run'] = $export->getNextRun();
							$export->save();
						}
						elseif ($export->datas['next_run'] <= time())
						{
							$filename = $this->preExportCatalog(false, 0, PHP_INT_MAX, 0, $export);
							$this->postExportCatalog(false, $export, $filename);
							echo date('r')."\tExport ".$export->name.PHP_EOL;
							$export->datas['next_run'] = $export->getNextRun();
							$export->save();
						}
					}
					// find next shop to export
					if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					{
						sort($id_shops);
						$this->config->_next_shop = $id_shops[0];
						foreach ($id_shops as $key => $id_shop)
							if ($id_shop == Configuration::get('PS_SHOP_DEFAULT'))
							{
								if (isset($id_shops[$key + 1]))
									$this->config->_next_shop = $id_shops[$key + 1];
								break;
							}
					}
				}
			}
			else
				throw new Exception('Forbidden access');
		}

		/**
		 * used by jqueryFileTree
		 * called by ajax
		 * @return void
		 */
		public function getFileTree()
		{
			$dir = Tools::getValue('dir');
			if ($dir == '')
			{
				echo '<ul class="jqueryFileTree" style="display: none;">';
				if (Tools::getValue('dontsave'))
					echo '<li><a class="selected file delete" href="#" rel="">'.$this->l('Do not save').'</a></li>';
				echo '<li><a class="directory '.(!is_writable(_PS_ROOT_DIR_)?'readonly ':'').'collapsed" href="#" rel="/">'.$this->l('Root').'</a></li>';
				echo '</ul>';
			}
			elseif (file_exists(_PS_ROOT_DIR_.$dir))
			{
				$files = scandir(_PS_ROOT_DIR_.$dir);
				natcasesort($files);
				if (count($files) > 2) /* The 2 accounts for . and .. */
				{
					echo '<ul class="jqueryFileTree" style="display: none;">';
					// All dirs
					foreach ($files as $file)
					{
						if (file_exists(_PS_ROOT_DIR_.$dir.$file)
							&& $file != '.'
							&& $file != '..'
							&& is_dir(_PS_ROOT_DIR_.$dir.$file))
						{
							echo '<li><a class="directory '.(!is_writable(_PS_ROOT_DIR_.$dir.$file)?'readonly ':'').'collapsed" ';
							echo 'href="#" rel="'.htmlentities($dir.$file).'/">'.htmlentities($file).'</a></li>';
						}
					}
					echo '</ul>';
				}
			}
		}
	}
}
