<?php
/**
* 2007-2018 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author    EnvoiMoinsCher <api@boxtal.com>
* @copyright 2007-2018 PrestaShop SA / 2011-2018 EnvoiMoinsCher
* @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
* International Registred Trademark & Property of PrestaShop SA
*/

class EnvoimoinscherAjaxModuleFrontController extends ModuleFrontController
{
    protected $result;

    public function __construct()
    {
        //$this->bootstrap = true;
        $this->className = 'FrontEnvoiMoinsCherController';
        include_once(_PS_MODULE_DIR_ . '/envoimoinscher/envoimoinscher.php');
        parent::__construct();
        $this->result = '';
    }

    public function postProcess()
    {
        $emc = new Envoimoinscher();
        $option = Tools::getValue('option'); // Get option

        // getModuleLink
        //$link = new Link();
        //$admin_link_base = $link->getAdminLink($emc->name,'getModuleLink');

        switch ($option) {
            case 'get_points':
                $this->result = $emc->getPoints(
                    (int)Tools::getValue('idCarrier'),
                    Tools::getValue('postcode'),
                    Tools::getValue('city'),
                    Tools::getValue('country')
                );
                break;
            case 'set_point':
                $this->result = $emc->setPoint(Tools::getValue('point'));
                break;
            case 'push':
                $this->result = (int)$emc->handlePush();
                break;
            case 'choixRelais':
                die(require(_PS_MODULE_DIR_ . 'envoimoinscher/ajax/choix-relais.php'));
            case 'ip_geoloc':
                $this->result = $emc->ipGeoloc($_SERVER);
                break;
        }

        die($this->display());
    }

    public function display()
    {
        echo $this->result;
        //die();
    }

    public function displayContent()
    {
        $this->display();
    }

    public function smartyOutputContent($content)
    {
        $this->display();
    }
}
