<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from Common-Services Co., Ltd.
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: contact@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe Common-Services Co., Ltd.
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la Common-Services Co. Ltd. est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter Common-Services Co., Ltd. a l'adresse: contact@common-services.com
 *
 * @author    Olivier B.
 * @copyright Copyright (c) 2011-2018 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @license   Commercial license
 * @package   Amazon Market Place
 * Support by mail:  support.amazon@common-services.com
*/

require_once(dirname(__FILE__).'/env.php');
require_once(dirname(__FILE__).'/../amazon.php');
require_once(dirname(__FILE__).'/../classes/amazon.webservice.class.php');
require_once(dirname(__FILE__).'/../classes/amazon.orders_reports.class.php');
require_once(dirname(__FILE__).'/../classes/amazon.support.class.php');
require_once(dirname(__FILE__).'/../classes/amazon.remote_cart.class.php');

class AmazonOrdersReport extends Amazon
{
    const ACTION_CHECK  = 'check';
    const ACTION_ACTIVATE = 'activate';
    const ACTION_ERROR = 'error';
    const ACTION_REPORT_REQUEST = 'report-request';
    const ACTION_REPORT_REQUEST_LIST = 'report-request-list';
    const ACTION_REPORT_GET = 'report-get';
    const ACTION_REPORT_PARSE = 'report-parse';

    public $ws = null;
    public $marketplaceId = null;
    public $region = null;
    public $merchantId = null;
    public $amazon_id_lang = null;

    public static $errors     = array();
    public static $warnings   = array();
    public static $messages   = array();
    public static $next_action   = array();




    public static function jsonDisplayExit()
    {
        if ($result = ob_get_clean()) {
            $output = $result;
        } else {
            $output = null;
        }

        $data = array(
            'error' => (count(AmazonOrdersReport::$errors) ? true : false),
            'errors' => AmazonOrdersReport::$errors,
            'message' => (count(self::$messages) ? true : false),
            'messages' => self::$messages,
            'output' => $output,
            'next_action' => self::$next_action
        );

        $json = Tools::jsonEncode($data);

        if (Amazon::$debug_mode) {
            die;
        } elseif ($callback = Tools::getValue('callback')) {
            // jquery

            echo (string)$callback.'('.$json.')';
            die;
        } else {
            // cron

            echo $json;
            die;
        }
    }

    public function dispatch()
    {
        if (!self::ENABLE_EXPERIMENTAL_FEATURES) {
            return(false);
        }

        //register_shutdown_function(array('AmazonOrdersReport', 'jsonDisplayExit'));

        if (Amazon::$debug_mode) {
            @ini_set('display_errors', 'on');
            @error_reporting(E_ALL | E_STRICT);
        }
        $action = Tools::getValue('action');

        switch ($action) {
         /*   case self::ACTION_CHECK:
                if ($this->init()) {
                    $this->getReportScheduleList();
                };
                break;
            case self::ACTION_ACTIVATE:
                if ($this->init()) {
                    $this->manageReportSchedule();
                };
                break;*/
            case self::ACTION_REPORT_REQUEST:
                if ($this->init()) {
                    $startDate = date('c', strtotime('now -1 days'));
                    $endDate = date('c', strtotime('now'));

                    $this->ws->reportRequest($startDate, $endDate);
                };
                break;
            case self::ACTION_REPORT_REQUEST_LIST:
                if ($this->init()) {
                    $this->ws->reportRequestList();
                };
                break;
            case self::ACTION_REPORT_GET:
                if ($this->init()) {
                    $this->ws->getReport(Tools::getValue('report_id'));
                };
                break;
            case self::ACTION_REPORT_PARSE:
                if ($this->init()) {
                    $this->ws->parseReport(dirname(__FILE__).'/../demo/orders_report.csv');
                }
                break;
            default:
                die('Unknow action: '.$action);
                break;
        }
    }


    public function init()
    {
        $tokens = Tools::getValue('amazon_token');

        $id_lang = (int)Tools::getValue('amazon_lang');


        $marketPlaceRegion = unserialize(AmazonTools::decode(Configuration::get('AMAZON_REGION')));
        $marketPlaceIds = unserialize(AmazonTools::decode(Configuration::get('AMAZON_MARKETPLACE_ID')));
        $marketLang2Region = array_flip($marketPlaceRegion);

        if ((int)Tools::getValue('europe')) {
            $masterMarketplace = unserialize(AmazonTools::decode(Configuration::get('AMAZON_MASTER')));

            if (isset($marketLang2Region[$masterMarketplace]) && $marketLang2Region[$masterMarketplace]) {
                $id_lang = $marketLang2Region[$masterMarketplace];
            } else {
                $id_lang = (int)Configuration::get('PS_LANG_DEFAULT');
            }

            $this->europe = 1;
        } else {
            $this->europe = 0;
        }

        if (!is_array($marketPlaceRegion) || !count($marketPlaceRegion)) {
            self::$errors[] = $error = $this->l('Module is not configured yet');

            if (Amazon::$debug_mode) {
                echo '<pre>'.Amazon::LF;
                printf('%s(#%d): init(): Failed - %s', basename(__FILE__), __LINE__, $error);
                echo "</pre>".Amazon::LF;
            }
            die;
        }

        if (!isset($marketPlaceRegion[$id_lang]) || !$marketPlaceRegion[$id_lang]) {
            self::$errors[] = $error =  $this->l('No selected language, nothing to do...');

            if (Amazon::$debug_mode) {
                echo '<pre>'.Amazon::LF;
                printf('%s(#%d): init(): Failed - %s', basename(__FILE__), __LINE__, $error);
                echo "</pre>".Amazon::LF;
            }
            die;
        }


        if (!AmazonTools::checkToken($tokens)) {
            self::$errors[] = $error = $this->l('Wrong Token');

            if (Amazon::$debug_mode) {
                echo '<pre>'.Amazon::LF;
                printf('%s(#%d): init(): Failed - %s', basename(__FILE__), __LINE__, $error);
                echo "</pre>".Amazon::LF;
            }
            die;
        }

        $amazon = AmazonTools::selectPlatforms($id_lang, 0);

        $this->marketplaceId = trim($marketPlaceIds[$id_lang]);
        $this->region = trim($amazon['params']['Country']);
        $this->merchantId = trim($amazon['auth']['MerchantID']);

        if (Amazon::$debug_mode) {
            printf('Webservice Params: %s'.Amazon::LF, nl2br(print_r($amazon, true)));
        }
        $this->ws = new AmazonOrdersReports($amazon['auth'], $amazon['params'], null, Amazon::$debug_mode);

        $marketPlaceIds = unserialize(AmazonTools::decode(Configuration::get('AMAZON_MARKETPLACE_ID')));

        if (!isset($marketPlaceIds[$id_lang]) || !$marketPlaceIds[$id_lang]) {
            $lang = new Language($id_lang);

            self::$errors[] = $error = sprintf('%s "%s"', $this->l('Marketplace is not yet configured for'), $lang->name);

            if (Amazon::$debug_mode) {
                echo '<pre>'.Amazon::LF;
                printf('%s(#%d): %s'.Amazon::LF, basename(__FILE__), __LINE__, $error);
                echo "</pre>".Amazon::LF;
            }
            die;
        }
        return(true);
    }
}

$amazonOrdersReport = new AmazonOrdersReport();
$amazonOrdersReport->dispatch();
