<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from Common-Services Co., Ltd.
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: contact@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe Common-Services Co., Ltd.
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la Common-Services Co. Ltd. est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter Common-Services Co., Ltd. a l'adresse: contact@common-services.com
 *
 * @author    Olivier B.
 * @copyright Copyright (c) 2011-2018 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @license   Commercial license
 * @package   Common-Classes
 * Support by mail:  support@common-services.com
 */

if (! class_exists('CommonConfiguration')) {
    class CommonConfiguration extends Configuration
    {
        // Override-able
        public static $module;
        public static $configuration_table = 'marketplace_configuration';

        public static $definition_backup;

        // Override Configuration definition
        public static function setDefinition()
        {
            self::$definition_backup = Configuration::$definition;
            Configuration::$definition['table'] = static::$configuration_table;
        }

        // Restore Configuration definition
        public static function unsetDefinition()
        {
            Configuration::$definition = self::$definition_backup;
        }

        /**
         * Update configuration value
         * @param string $configuration_key
         * @param mixed $data
         * @param bool $html
         * @param null $id_shop_group
         * @param null $id_shop
         *
         * @return bool
         */
        public static function updateValue($configuration_key, $data, $html = false, $id_shop_group = null, $id_shop = null)
        {
            $prestashop_configuration_key  = sprintf(static::$module . '_%s', Tools::strtoupper($configuration_key));
            $marketplace_configuration_key = Tools::strtolower($configuration_key);

            $id_shop       = Shop::getContextShopID(true);
            $id_shop_group = Shop::getContextShopGroupID(true);
            $data_encode   = base64_encode(serialize($data));

            // update on specific module table
            if (CommonTools::tableExists(_DB_PREFIX_ . static::$configuration_table)) {
                self::setDefinition();
                // New table not encrypt data
                $result = Configuration::updateValue($prestashop_configuration_key, serialize($data), $html, $id_shop_group, $id_shop);
                self::unsetDefinition();
                return $result;
            }

            // Update on general table if specific table not exist
            if (CommonTools::tableExists(_DB_PREFIX_ . self::$configuration_table)) {
                $sql = 'REPLACE INTO `' . _DB_PREFIX_ . self::$configuration_table . '`(`marketplace`, `configuration`, `value`) 
                        VALUES("' . pSQL(static::$module) . '", "' . pSQL($marketplace_configuration_key) . '", "' . $data_encode . '")';
                return Db::getInstance()->execute($sql);
            }

            // Last try on ps table
            if (version_compare(_PS_VERSION_, '1.5', '>=')) {
                return Configuration::updateValue($prestashop_configuration_key, $data_encode, $html, $id_shop_group, $id_shop);
            } else {
                return Configuration::updateGlobalValue($prestashop_configuration_key, $data_encode);
            }
        }

        /**
         * Get configuration from default table, if not exist get from ps table
         * @param string $configuration_key
         * @param null $id_lang
         * @param null $id_shop_group
         * @param null $id_shop
         *
         * @return mixed|string
         */
        public static function get($configuration_key, $id_lang = null, $id_shop_group = null, $id_shop = null)
        {
            $prestashop_configuration_key  = sprintf(static::$module . '_%s', Tools::strtoupper($configuration_key));
            $marketplace_configuration_key = Tools::strtolower($configuration_key);

            // Query on child table, use static::$configuration_table
            if (CommonTools::tableExists(_DB_PREFIX_ . static::$configuration_table)) {
                self::setDefinition();
                $result = Configuration::get($prestashop_configuration_key, $id_lang, $id_shop_group, $id_shop);
                self::unsetDefinition();

                if ($result) {
                    // New table not encrypt data
                    return unserialize($result);
                }
            }

            // If specific module table does not contain the value, up to general table
            if (CommonTools::tableExists(_DB_PREFIX_ . self::$configuration_table)) {
                $sql = 'SELECT `value`
                    FROM `' . _DB_PREFIX_ . self::$configuration_table . '`
                    WHERE `marketplace` = "' . pSQL(static::$module) . '"
                    AND `configuration` = "' . pSQL($marketplace_configuration_key) . '"';
                $result = Db::getInstance()->getRow($sql);

                if ($result && isset($result, $result['value'])) {
                    return unserialize(base64_decode($result['value']));
                }
            }

            // Old table also doesn't have the value, last try on ps table
            if (version_compare(_PS_VERSION_, '1.5', '>=')) {
                return unserialize(base64_decode(Configuration::get($prestashop_configuration_key, $id_lang, $id_shop_group, $id_shop)));
            } else {
                return unserialize(base64_decode(Configuration::getGlobalValue($prestashop_configuration_key, $id_lang)));
            }
        }

        /**
         * Check if Combination is active
         * @return bool
         */
        public static function combinationIsFeatureActive()
        {
            if (version_compare(_PS_VERSION_, '1.5', '<')) {
                return(true);
            } else {
                return(Combination::isFeatureActive());
            }
        }

        /**
         * Check if Feature if active
         * @return bool
         */
        public static function featureIsFeatureActive()
        {
            if (version_compare(_PS_VERSION_, '1.5', '<')) {
                return(true);
            } else {
                return(Feature::isFeatureActive());
            }
        }

        /**
         * Check if multishop is active
         * @return bool
         */
        public static function shopIsFeatureActive()
        {
            if (version_compare(_PS_VERSION_, '1.5', '<')) {
                return(false);
            } else {
                return(Shop::isFeatureActive());
            }
        }
    }
}
